// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions T_Inv_2TParameter Set.
 */
public class WorkbookFunctionsT_Inv_2TParameterSet {
    /**
     * The probability.
     * 
     */
    @SerializedName(value = "probability", alternate = {"Probability"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement probability;

    /**
     * The deg Freedom.
     * 
     */
    @SerializedName(value = "degFreedom", alternate = {"DegFreedom"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement degFreedom;


    /**
     * Instiaciates a new WorkbookFunctionsT_Inv_2TParameterSet
     */
    public WorkbookFunctionsT_Inv_2TParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsT_Inv_2TParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsT_Inv_2TParameterSet(@Nonnull final WorkbookFunctionsT_Inv_2TParameterSetBuilder builder) {
        this.probability = builder.probability;
        this.degFreedom = builder.degFreedom;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsT_Inv_2TParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsT_Inv_2TParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsT_Inv_2TParameterSet
     */
    public static final class WorkbookFunctionsT_Inv_2TParameterSetBuilder {
        /**
         * The probability parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement probability;
        /**
         * Sets the Probability
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsT_Inv_2TParameterSetBuilder withProbability(@Nullable final com.google.gson.JsonElement val) {
            this.probability = val;
            return this;
        }
        /**
         * The degFreedom parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement degFreedom;
        /**
         * Sets the DegFreedom
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsT_Inv_2TParameterSetBuilder withDegFreedom(@Nullable final com.google.gson.JsonElement val) {
            this.degFreedom = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsT_Inv_2TParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsT_Inv_2TParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsT_Inv_2TParameterSet build() {
            return new WorkbookFunctionsT_Inv_2TParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.probability != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("probability", probability));
        }
        if(this.degFreedom != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("degFreedom", degFreedom));
        }
        return result;
    }
}
