// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Work Day_Intl Parameter Set.
 */
public class WorkbookFunctionsWorkDay_IntlParameterSet {
    /**
     * The start Date.
     * 
     */
    @SerializedName(value = "startDate", alternate = {"StartDate"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement startDate;

    /**
     * The days.
     * 
     */
    @SerializedName(value = "days", alternate = {"Days"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement days;

    /**
     * The weekend.
     * 
     */
    @SerializedName(value = "weekend", alternate = {"Weekend"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement weekend;

    /**
     * The holidays.
     * 
     */
    @SerializedName(value = "holidays", alternate = {"Holidays"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement holidays;


    /**
     * Instiaciates a new WorkbookFunctionsWorkDay_IntlParameterSet
     */
    public WorkbookFunctionsWorkDay_IntlParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsWorkDay_IntlParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsWorkDay_IntlParameterSet(@Nonnull final WorkbookFunctionsWorkDay_IntlParameterSetBuilder builder) {
        this.startDate = builder.startDate;
        this.days = builder.days;
        this.weekend = builder.weekend;
        this.holidays = builder.holidays;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsWorkDay_IntlParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsWorkDay_IntlParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsWorkDay_IntlParameterSet
     */
    public static final class WorkbookFunctionsWorkDay_IntlParameterSetBuilder {
        /**
         * The startDate parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement startDate;
        /**
         * Sets the StartDate
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsWorkDay_IntlParameterSetBuilder withStartDate(@Nullable final com.google.gson.JsonElement val) {
            this.startDate = val;
            return this;
        }
        /**
         * The days parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement days;
        /**
         * Sets the Days
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsWorkDay_IntlParameterSetBuilder withDays(@Nullable final com.google.gson.JsonElement val) {
            this.days = val;
            return this;
        }
        /**
         * The weekend parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement weekend;
        /**
         * Sets the Weekend
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsWorkDay_IntlParameterSetBuilder withWeekend(@Nullable final com.google.gson.JsonElement val) {
            this.weekend = val;
            return this;
        }
        /**
         * The holidays parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement holidays;
        /**
         * Sets the Holidays
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsWorkDay_IntlParameterSetBuilder withHolidays(@Nullable final com.google.gson.JsonElement val) {
            this.holidays = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsWorkDay_IntlParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsWorkDay_IntlParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsWorkDay_IntlParameterSet build() {
            return new WorkbookFunctionsWorkDay_IntlParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.startDate != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("startDate", startDate));
        }
        if(this.days != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("days", days));
        }
        if(this.weekend != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("weekend", weekend));
        }
        if(this.holidays != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("holidays", holidays));
        }
        return result;
    }
}
