// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookTable;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Table Add Parameter Set.
 */
public class WorkbookTableAddParameterSet {
    /**
     * The address.
     * 
     */
    @SerializedName(value = "address", alternate = {"Address"})
    @Expose
	@Nullable
    public String address;

    /**
     * The has Headers.
     * 
     */
    @SerializedName(value = "hasHeaders", alternate = {"HasHeaders"})
    @Expose
	@Nullable
    public Boolean hasHeaders;


    /**
     * Instiaciates a new WorkbookTableAddParameterSet
     */
    public WorkbookTableAddParameterSet() {}
    /**
     * Instiaciates a new WorkbookTableAddParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookTableAddParameterSet(@Nonnull final WorkbookTableAddParameterSetBuilder builder) {
        this.address = builder.address;
        this.hasHeaders = builder.hasHeaders;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookTableAddParameterSetBuilder newBuilder() {
        return new WorkbookTableAddParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookTableAddParameterSet
     */
    public static final class WorkbookTableAddParameterSetBuilder {
        /**
         * The address parameter value
         */
        @Nullable
        protected String address;
        /**
         * Sets the Address
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookTableAddParameterSetBuilder withAddress(@Nullable final String val) {
            this.address = val;
            return this;
        }
        /**
         * The hasHeaders parameter value
         */
        @Nullable
        protected Boolean hasHeaders;
        /**
         * Sets the HasHeaders
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookTableAddParameterSetBuilder withHasHeaders(@Nullable final Boolean val) {
            this.hasHeaders = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookTableAddParameterSetBuilder
         */
        @Nullable
        protected WorkbookTableAddParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookTableAddParameterSet build() {
            return new WorkbookTableAddParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.address != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("address", address));
        }
        if(this.hasHeaders != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("hasHeaders", hasHeaders));
        }
        return result;
    }
}
