// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageResourceScope;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Resource Scope Request.
 */
public class AccessPackageResourceScopeRequest extends BaseRequest<AccessPackageResourceScope> {
	
    /**
     * The request for the AccessPackageResourceScope
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageResourceScopeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageResourceScope.class);
    }

    /**
     * Gets the AccessPackageResourceScope from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceScope> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackageResourceScope from the service
     *
     * @return the AccessPackageResourceScope from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceScope get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceScope> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackageResourceScope delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackageResourceScope with a source
     *
     * @param sourceAccessPackageResourceScope the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceScope> patchAsync(@Nonnull final AccessPackageResourceScope sourceAccessPackageResourceScope) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackageResourceScope);
    }

    /**
     * Patches this AccessPackageResourceScope with a source
     *
     * @param sourceAccessPackageResourceScope the source object with updates
     * @return the updated AccessPackageResourceScope
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceScope patch(@Nonnull final AccessPackageResourceScope sourceAccessPackageResourceScope) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackageResourceScope);
    }

    /**
     * Creates a AccessPackageResourceScope with a new object
     *
     * @param newAccessPackageResourceScope the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceScope> postAsync(@Nonnull final AccessPackageResourceScope newAccessPackageResourceScope) {
        return sendAsync(HttpMethod.POST, newAccessPackageResourceScope);
    }

    /**
     * Creates a AccessPackageResourceScope with a new object
     *
     * @param newAccessPackageResourceScope the new object to create
     * @return the created AccessPackageResourceScope
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceScope post(@Nonnull final AccessPackageResourceScope newAccessPackageResourceScope) throws ClientException {
        return send(HttpMethod.POST, newAccessPackageResourceScope);
    }

    /**
     * Creates a AccessPackageResourceScope with a new object
     *
     * @param newAccessPackageResourceScope the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageResourceScope> putAsync(@Nonnull final AccessPackageResourceScope newAccessPackageResourceScope) {
        return sendAsync(HttpMethod.PUT, newAccessPackageResourceScope);
    }

    /**
     * Creates a AccessPackageResourceScope with a new object
     *
     * @param newAccessPackageResourceScope the object to create/update
     * @return the created AccessPackageResourceScope
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageResourceScope put(@Nonnull final AccessPackageResourceScope newAccessPackageResourceScope) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackageResourceScope);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageResourceScopeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageResourceScopeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

