// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessReviewHistoryInstance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review History Instance Request.
 */
public class AccessReviewHistoryInstanceRequest extends BaseRequest<AccessReviewHistoryInstance> {
	
    /**
     * The request for the AccessReviewHistoryInstance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewHistoryInstanceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessReviewHistoryInstance.class);
    }

    /**
     * Gets the AccessReviewHistoryInstance from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewHistoryInstance> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessReviewHistoryInstance from the service
     *
     * @return the AccessReviewHistoryInstance from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewHistoryInstance get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewHistoryInstance> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessReviewHistoryInstance delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessReviewHistoryInstance with a source
     *
     * @param sourceAccessReviewHistoryInstance the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewHistoryInstance> patchAsync(@Nonnull final AccessReviewHistoryInstance sourceAccessReviewHistoryInstance) {
        return sendAsync(HttpMethod.PATCH, sourceAccessReviewHistoryInstance);
    }

    /**
     * Patches this AccessReviewHistoryInstance with a source
     *
     * @param sourceAccessReviewHistoryInstance the source object with updates
     * @return the updated AccessReviewHistoryInstance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewHistoryInstance patch(@Nonnull final AccessReviewHistoryInstance sourceAccessReviewHistoryInstance) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessReviewHistoryInstance);
    }

    /**
     * Creates a AccessReviewHistoryInstance with a new object
     *
     * @param newAccessReviewHistoryInstance the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewHistoryInstance> postAsync(@Nonnull final AccessReviewHistoryInstance newAccessReviewHistoryInstance) {
        return sendAsync(HttpMethod.POST, newAccessReviewHistoryInstance);
    }

    /**
     * Creates a AccessReviewHistoryInstance with a new object
     *
     * @param newAccessReviewHistoryInstance the new object to create
     * @return the created AccessReviewHistoryInstance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewHistoryInstance post(@Nonnull final AccessReviewHistoryInstance newAccessReviewHistoryInstance) throws ClientException {
        return send(HttpMethod.POST, newAccessReviewHistoryInstance);
    }

    /**
     * Creates a AccessReviewHistoryInstance with a new object
     *
     * @param newAccessReviewHistoryInstance the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewHistoryInstance> putAsync(@Nonnull final AccessReviewHistoryInstance newAccessReviewHistoryInstance) {
        return sendAsync(HttpMethod.PUT, newAccessReviewHistoryInstance);
    }

    /**
     * Creates a AccessReviewHistoryInstance with a new object
     *
     * @param newAccessReviewHistoryInstance the object to create/update
     * @return the created AccessReviewHistoryInstance
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewHistoryInstance put(@Nonnull final AccessReviewHistoryInstance newAccessReviewHistoryInstance) throws ClientException {
        return send(HttpMethod.PUT, newAccessReviewHistoryInstance);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewHistoryInstanceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewHistoryInstanceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

