// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.User;
import com.microsoft.graph.models.AgreementAcceptance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AgreementAcceptanceCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.AgreementAcceptanceCollectionWithReferencesPage;
import com.microsoft.graph.requests.AgreementAcceptanceCollectionResponse;
import com.microsoft.graph.models.AgreementAcceptance;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Agreement Acceptance Collection With References Page.
 */
public class AgreementAcceptanceCollectionWithReferencesPage extends BaseCollectionPage<AgreementAcceptance, AgreementAcceptanceCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for AgreementAcceptance
     *
     * @param response the serialized AgreementAcceptanceCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public AgreementAcceptanceCollectionWithReferencesPage(@Nonnull final AgreementAcceptanceCollectionResponse response, @Nullable final AgreementAcceptanceCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for AgreementAcceptance
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public AgreementAcceptanceCollectionWithReferencesPage(@Nonnull final java.util.List<AgreementAcceptance> pageContents, @Nullable final AgreementAcceptanceCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
