// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AndroidCustomConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Android Custom Configuration Request.
 */
public class AndroidCustomConfigurationRequest extends BaseRequest<AndroidCustomConfiguration> {
	
    /**
     * The request for the AndroidCustomConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AndroidCustomConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AndroidCustomConfiguration.class);
    }

    /**
     * Gets the AndroidCustomConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCustomConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AndroidCustomConfiguration from the service
     *
     * @return the AndroidCustomConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidCustomConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCustomConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AndroidCustomConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AndroidCustomConfiguration with a source
     *
     * @param sourceAndroidCustomConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCustomConfiguration> patchAsync(@Nonnull final AndroidCustomConfiguration sourceAndroidCustomConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceAndroidCustomConfiguration);
    }

    /**
     * Patches this AndroidCustomConfiguration with a source
     *
     * @param sourceAndroidCustomConfiguration the source object with updates
     * @return the updated AndroidCustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidCustomConfiguration patch(@Nonnull final AndroidCustomConfiguration sourceAndroidCustomConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceAndroidCustomConfiguration);
    }

    /**
     * Creates a AndroidCustomConfiguration with a new object
     *
     * @param newAndroidCustomConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCustomConfiguration> postAsync(@Nonnull final AndroidCustomConfiguration newAndroidCustomConfiguration) {
        return sendAsync(HttpMethod.POST, newAndroidCustomConfiguration);
    }

    /**
     * Creates a AndroidCustomConfiguration with a new object
     *
     * @param newAndroidCustomConfiguration the new object to create
     * @return the created AndroidCustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidCustomConfiguration post(@Nonnull final AndroidCustomConfiguration newAndroidCustomConfiguration) throws ClientException {
        return send(HttpMethod.POST, newAndroidCustomConfiguration);
    }

    /**
     * Creates a AndroidCustomConfiguration with a new object
     *
     * @param newAndroidCustomConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidCustomConfiguration> putAsync(@Nonnull final AndroidCustomConfiguration newAndroidCustomConfiguration) {
        return sendAsync(HttpMethod.PUT, newAndroidCustomConfiguration);
    }

    /**
     * Creates a AndroidCustomConfiguration with a new object
     *
     * @param newAndroidCustomConfiguration the object to create/update
     * @return the created AndroidCustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidCustomConfiguration put(@Nonnull final AndroidCustomConfiguration newAndroidCustomConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newAndroidCustomConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AndroidCustomConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AndroidCustomConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

