// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ApprovalFilterByCurrentUserOptions;
import com.microsoft.graph.models.Approval;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ApprovalFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.ApprovalFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.ApprovalFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.ApprovalFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Approval Filter By Current User Collection Request Builder.
 */
public class ApprovalFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<Approval, ApprovalFilterByCurrentUserCollectionRequestBuilder, ApprovalFilterByCurrentUserCollectionResponse, ApprovalFilterByCurrentUserCollectionPage, ApprovalFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of Approval
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ApprovalFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ApprovalFilterByCurrentUserCollectionRequestBuilder.class, ApprovalFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of Approval
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ApprovalFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ApprovalFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, ApprovalFilterByCurrentUserCollectionRequestBuilder.class, ApprovalFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ApprovalFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public ApprovalFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ApprovalFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
        if(functionOptions != null) {    
            for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
                request.addFunctionOption(option);
            }
        }
        return request;
    }
}
