// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AttributeSet;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attribute Set Request.
 */
public class AttributeSetRequest extends BaseRequest<AttributeSet> {
	
    /**
     * The request for the AttributeSet
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AttributeSetRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AttributeSet.class);
    }

    /**
     * Gets the AttributeSet from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeSet> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AttributeSet from the service
     *
     * @return the AttributeSet from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttributeSet get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeSet> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AttributeSet delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AttributeSet with a source
     *
     * @param sourceAttributeSet the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeSet> patchAsync(@Nonnull final AttributeSet sourceAttributeSet) {
        return sendAsync(HttpMethod.PATCH, sourceAttributeSet);
    }

    /**
     * Patches this AttributeSet with a source
     *
     * @param sourceAttributeSet the source object with updates
     * @return the updated AttributeSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttributeSet patch(@Nonnull final AttributeSet sourceAttributeSet) throws ClientException {
        return send(HttpMethod.PATCH, sourceAttributeSet);
    }

    /**
     * Creates a AttributeSet with a new object
     *
     * @param newAttributeSet the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeSet> postAsync(@Nonnull final AttributeSet newAttributeSet) {
        return sendAsync(HttpMethod.POST, newAttributeSet);
    }

    /**
     * Creates a AttributeSet with a new object
     *
     * @param newAttributeSet the new object to create
     * @return the created AttributeSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttributeSet post(@Nonnull final AttributeSet newAttributeSet) throws ClientException {
        return send(HttpMethod.POST, newAttributeSet);
    }

    /**
     * Creates a AttributeSet with a new object
     *
     * @param newAttributeSet the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttributeSet> putAsync(@Nonnull final AttributeSet newAttributeSet) {
        return sendAsync(HttpMethod.PUT, newAttributeSet);
    }

    /**
     * Creates a AttributeSet with a new object
     *
     * @param newAttributeSet the object to create/update
     * @return the created AttributeSet
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttributeSet put(@Nonnull final AttributeSet newAttributeSet) throws ClientException {
        return send(HttpMethod.PUT, newAttributeSet);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AttributeSetRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AttributeSetRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

