// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Bitlocker;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Bitlocker Request.
 */
public class BitlockerRequest extends BaseRequest<Bitlocker> {
	
    /**
     * The request for the Bitlocker
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BitlockerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Bitlocker.class);
    }

    /**
     * Gets the Bitlocker from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Bitlocker> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Bitlocker from the service
     *
     * @return the Bitlocker from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Bitlocker get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Bitlocker> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Bitlocker delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Bitlocker with a source
     *
     * @param sourceBitlocker the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Bitlocker> patchAsync(@Nonnull final Bitlocker sourceBitlocker) {
        return sendAsync(HttpMethod.PATCH, sourceBitlocker);
    }

    /**
     * Patches this Bitlocker with a source
     *
     * @param sourceBitlocker the source object with updates
     * @return the updated Bitlocker
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Bitlocker patch(@Nonnull final Bitlocker sourceBitlocker) throws ClientException {
        return send(HttpMethod.PATCH, sourceBitlocker);
    }

    /**
     * Creates a Bitlocker with a new object
     *
     * @param newBitlocker the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Bitlocker> postAsync(@Nonnull final Bitlocker newBitlocker) {
        return sendAsync(HttpMethod.POST, newBitlocker);
    }

    /**
     * Creates a Bitlocker with a new object
     *
     * @param newBitlocker the new object to create
     * @return the created Bitlocker
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Bitlocker post(@Nonnull final Bitlocker newBitlocker) throws ClientException {
        return send(HttpMethod.POST, newBitlocker);
    }

    /**
     * Creates a Bitlocker with a new object
     *
     * @param newBitlocker the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Bitlocker> putAsync(@Nonnull final Bitlocker newBitlocker) {
        return sendAsync(HttpMethod.PUT, newBitlocker);
    }

    /**
     * Creates a Bitlocker with a new object
     *
     * @param newBitlocker the object to create/update
     * @return the created Bitlocker
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Bitlocker put(@Nonnull final Bitlocker newBitlocker) throws ClientException {
        return send(HttpMethod.PUT, newBitlocker);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BitlockerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BitlockerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

