// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.BookingService;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Booking Service Request.
 */
public class BookingServiceRequest extends BaseRequest<BookingService> {
	
    /**
     * The request for the BookingService
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BookingServiceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, BookingService.class);
    }

    /**
     * Gets the BookingService from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingService> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the BookingService from the service
     *
     * @return the BookingService from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingService get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingService> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public BookingService delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this BookingService with a source
     *
     * @param sourceBookingService the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingService> patchAsync(@Nonnull final BookingService sourceBookingService) {
        return sendAsync(HttpMethod.PATCH, sourceBookingService);
    }

    /**
     * Patches this BookingService with a source
     *
     * @param sourceBookingService the source object with updates
     * @return the updated BookingService
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingService patch(@Nonnull final BookingService sourceBookingService) throws ClientException {
        return send(HttpMethod.PATCH, sourceBookingService);
    }

    /**
     * Creates a BookingService with a new object
     *
     * @param newBookingService the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingService> postAsync(@Nonnull final BookingService newBookingService) {
        return sendAsync(HttpMethod.POST, newBookingService);
    }

    /**
     * Creates a BookingService with a new object
     *
     * @param newBookingService the new object to create
     * @return the created BookingService
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingService post(@Nonnull final BookingService newBookingService) throws ClientException {
        return send(HttpMethod.POST, newBookingService);
    }

    /**
     * Creates a BookingService with a new object
     *
     * @param newBookingService the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<BookingService> putAsync(@Nonnull final BookingService newBookingService) {
        return sendAsync(HttpMethod.PUT, newBookingService);
    }

    /**
     * Creates a BookingService with a new object
     *
     * @param newBookingService the object to create/update
     * @return the created BookingService
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public BookingService put(@Nonnull final BookingService newBookingService) throws ClientException {
        return send(HttpMethod.PUT, newBookingService);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public BookingServiceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public BookingServiceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

