// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.ChatUnhideForUserRequest;
import com.microsoft.graph.models.Chat;
import com.microsoft.graph.models.TeamworkUserIdentity;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.ChatUnhideForUserParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Unhide For User Request Builder.
 */
public class ChatUnhideForUserRequestBuilder extends BaseActionRequestBuilder<Chat> {

    /**
     * The request builder for this ChatUnhideForUser
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ChatUnhideForUserRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private ChatUnhideForUserParameterSet body;
    /**
     * The request builder for this ChatUnhideForUser
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ChatUnhideForUserRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ChatUnhideForUserParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the ChatUnhideForUserRequest
     *
     * @param requestOptions the options for the request
     * @return the ChatUnhideForUserRequest instance
     */
    @Nonnull
    public ChatUnhideForUserRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the ChatUnhideForUserRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ChatUnhideForUserRequest instance
     */
    @Nonnull
    public ChatUnhideForUserRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ChatUnhideForUserRequest request = new ChatUnhideForUserRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
