// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CrossTenantIdentitySyncPolicyPartner;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cross Tenant Identity Sync Policy Partner Request.
 */
public class CrossTenantIdentitySyncPolicyPartnerRequest extends BaseRequest<CrossTenantIdentitySyncPolicyPartner> {
	
    /**
     * The request for the CrossTenantIdentitySyncPolicyPartner
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CrossTenantIdentitySyncPolicyPartnerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CrossTenantIdentitySyncPolicyPartner.class);
    }

    /**
     * Gets the CrossTenantIdentitySyncPolicyPartner from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantIdentitySyncPolicyPartner> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CrossTenantIdentitySyncPolicyPartner from the service
     *
     * @return the CrossTenantIdentitySyncPolicyPartner from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantIdentitySyncPolicyPartner get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantIdentitySyncPolicyPartner> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CrossTenantIdentitySyncPolicyPartner delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CrossTenantIdentitySyncPolicyPartner with a source
     *
     * @param sourceCrossTenantIdentitySyncPolicyPartner the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantIdentitySyncPolicyPartner> patchAsync(@Nonnull final CrossTenantIdentitySyncPolicyPartner sourceCrossTenantIdentitySyncPolicyPartner) {
        return sendAsync(HttpMethod.PATCH, sourceCrossTenantIdentitySyncPolicyPartner);
    }

    /**
     * Patches this CrossTenantIdentitySyncPolicyPartner with a source
     *
     * @param sourceCrossTenantIdentitySyncPolicyPartner the source object with updates
     * @return the updated CrossTenantIdentitySyncPolicyPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantIdentitySyncPolicyPartner patch(@Nonnull final CrossTenantIdentitySyncPolicyPartner sourceCrossTenantIdentitySyncPolicyPartner) throws ClientException {
        return send(HttpMethod.PATCH, sourceCrossTenantIdentitySyncPolicyPartner);
    }

    /**
     * Creates a CrossTenantIdentitySyncPolicyPartner with a new object
     *
     * @param newCrossTenantIdentitySyncPolicyPartner the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantIdentitySyncPolicyPartner> postAsync(@Nonnull final CrossTenantIdentitySyncPolicyPartner newCrossTenantIdentitySyncPolicyPartner) {
        return sendAsync(HttpMethod.POST, newCrossTenantIdentitySyncPolicyPartner);
    }

    /**
     * Creates a CrossTenantIdentitySyncPolicyPartner with a new object
     *
     * @param newCrossTenantIdentitySyncPolicyPartner the new object to create
     * @return the created CrossTenantIdentitySyncPolicyPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantIdentitySyncPolicyPartner post(@Nonnull final CrossTenantIdentitySyncPolicyPartner newCrossTenantIdentitySyncPolicyPartner) throws ClientException {
        return send(HttpMethod.POST, newCrossTenantIdentitySyncPolicyPartner);
    }

    /**
     * Creates a CrossTenantIdentitySyncPolicyPartner with a new object
     *
     * @param newCrossTenantIdentitySyncPolicyPartner the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CrossTenantIdentitySyncPolicyPartner> putAsync(@Nonnull final CrossTenantIdentitySyncPolicyPartner newCrossTenantIdentitySyncPolicyPartner) {
        return sendAsync(HttpMethod.PUT, newCrossTenantIdentitySyncPolicyPartner);
    }

    /**
     * Creates a CrossTenantIdentitySyncPolicyPartner with a new object
     *
     * @param newCrossTenantIdentitySyncPolicyPartner the object to create/update
     * @return the created CrossTenantIdentitySyncPolicyPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CrossTenantIdentitySyncPolicyPartner put(@Nonnull final CrossTenantIdentitySyncPolicyPartner newCrossTenantIdentitySyncPolicyPartner) throws ClientException {
        return send(HttpMethod.PUT, newCrossTenantIdentitySyncPolicyPartner);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CrossTenantIdentitySyncPolicyPartnerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CrossTenantIdentitySyncPolicyPartnerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

