// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.CustomSecurityAttributeDefinition;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Custom Security Attribute Definition Request.
 */
public class CustomSecurityAttributeDefinitionRequest extends BaseRequest<CustomSecurityAttributeDefinition> {
	
    /**
     * The request for the CustomSecurityAttributeDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CustomSecurityAttributeDefinitionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CustomSecurityAttributeDefinition.class);
    }

    /**
     * Gets the CustomSecurityAttributeDefinition from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomSecurityAttributeDefinition> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the CustomSecurityAttributeDefinition from the service
     *
     * @return the CustomSecurityAttributeDefinition from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomSecurityAttributeDefinition get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomSecurityAttributeDefinition> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public CustomSecurityAttributeDefinition delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CustomSecurityAttributeDefinition with a source
     *
     * @param sourceCustomSecurityAttributeDefinition the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomSecurityAttributeDefinition> patchAsync(@Nonnull final CustomSecurityAttributeDefinition sourceCustomSecurityAttributeDefinition) {
        return sendAsync(HttpMethod.PATCH, sourceCustomSecurityAttributeDefinition);
    }

    /**
     * Patches this CustomSecurityAttributeDefinition with a source
     *
     * @param sourceCustomSecurityAttributeDefinition the source object with updates
     * @return the updated CustomSecurityAttributeDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomSecurityAttributeDefinition patch(@Nonnull final CustomSecurityAttributeDefinition sourceCustomSecurityAttributeDefinition) throws ClientException {
        return send(HttpMethod.PATCH, sourceCustomSecurityAttributeDefinition);
    }

    /**
     * Creates a CustomSecurityAttributeDefinition with a new object
     *
     * @param newCustomSecurityAttributeDefinition the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomSecurityAttributeDefinition> postAsync(@Nonnull final CustomSecurityAttributeDefinition newCustomSecurityAttributeDefinition) {
        return sendAsync(HttpMethod.POST, newCustomSecurityAttributeDefinition);
    }

    /**
     * Creates a CustomSecurityAttributeDefinition with a new object
     *
     * @param newCustomSecurityAttributeDefinition the new object to create
     * @return the created CustomSecurityAttributeDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomSecurityAttributeDefinition post(@Nonnull final CustomSecurityAttributeDefinition newCustomSecurityAttributeDefinition) throws ClientException {
        return send(HttpMethod.POST, newCustomSecurityAttributeDefinition);
    }

    /**
     * Creates a CustomSecurityAttributeDefinition with a new object
     *
     * @param newCustomSecurityAttributeDefinition the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<CustomSecurityAttributeDefinition> putAsync(@Nonnull final CustomSecurityAttributeDefinition newCustomSecurityAttributeDefinition) {
        return sendAsync(HttpMethod.PUT, newCustomSecurityAttributeDefinition);
    }

    /**
     * Creates a CustomSecurityAttributeDefinition with a new object
     *
     * @param newCustomSecurityAttributeDefinition the object to create/update
     * @return the created CustomSecurityAttributeDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public CustomSecurityAttributeDefinition put(@Nonnull final CustomSecurityAttributeDefinition newCustomSecurityAttributeDefinition) throws ClientException {
        return send(HttpMethod.PUT, newCustomSecurityAttributeDefinition);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public CustomSecurityAttributeDefinitionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public CustomSecurityAttributeDefinitionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

