// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DelegatedAdminCustomer;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Delegated Admin Customer Request.
 */
public class DelegatedAdminCustomerRequest extends BaseRequest<DelegatedAdminCustomer> {
	
    /**
     * The request for the DelegatedAdminCustomer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DelegatedAdminCustomerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DelegatedAdminCustomer.class);
    }

    /**
     * Gets the DelegatedAdminCustomer from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminCustomer> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DelegatedAdminCustomer from the service
     *
     * @return the DelegatedAdminCustomer from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminCustomer get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminCustomer> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DelegatedAdminCustomer delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DelegatedAdminCustomer with a source
     *
     * @param sourceDelegatedAdminCustomer the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminCustomer> patchAsync(@Nonnull final DelegatedAdminCustomer sourceDelegatedAdminCustomer) {
        return sendAsync(HttpMethod.PATCH, sourceDelegatedAdminCustomer);
    }

    /**
     * Patches this DelegatedAdminCustomer with a source
     *
     * @param sourceDelegatedAdminCustomer the source object with updates
     * @return the updated DelegatedAdminCustomer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminCustomer patch(@Nonnull final DelegatedAdminCustomer sourceDelegatedAdminCustomer) throws ClientException {
        return send(HttpMethod.PATCH, sourceDelegatedAdminCustomer);
    }

    /**
     * Creates a DelegatedAdminCustomer with a new object
     *
     * @param newDelegatedAdminCustomer the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminCustomer> postAsync(@Nonnull final DelegatedAdminCustomer newDelegatedAdminCustomer) {
        return sendAsync(HttpMethod.POST, newDelegatedAdminCustomer);
    }

    /**
     * Creates a DelegatedAdminCustomer with a new object
     *
     * @param newDelegatedAdminCustomer the new object to create
     * @return the created DelegatedAdminCustomer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminCustomer post(@Nonnull final DelegatedAdminCustomer newDelegatedAdminCustomer) throws ClientException {
        return send(HttpMethod.POST, newDelegatedAdminCustomer);
    }

    /**
     * Creates a DelegatedAdminCustomer with a new object
     *
     * @param newDelegatedAdminCustomer the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DelegatedAdminCustomer> putAsync(@Nonnull final DelegatedAdminCustomer newDelegatedAdminCustomer) {
        return sendAsync(HttpMethod.PUT, newDelegatedAdminCustomer);
    }

    /**
     * Creates a DelegatedAdminCustomer with a new object
     *
     * @param newDelegatedAdminCustomer the object to create/update
     * @return the created DelegatedAdminCustomer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DelegatedAdminCustomer put(@Nonnull final DelegatedAdminCustomer newDelegatedAdminCustomer) throws ClientException {
        return send(HttpMethod.PUT, newDelegatedAdminCustomer);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DelegatedAdminCustomerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DelegatedAdminCustomerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

