// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DeviceConfigurationState;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Configuration State Request.
 */
public class DeviceConfigurationStateRequest extends BaseRequest<DeviceConfigurationState> {
	
    /**
     * The request for the DeviceConfigurationState
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceConfigurationStateRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceConfigurationState.class);
    }

    /**
     * Gets the DeviceConfigurationState from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationState> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DeviceConfigurationState from the service
     *
     * @return the DeviceConfigurationState from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationState get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationState> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DeviceConfigurationState delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceConfigurationState with a source
     *
     * @param sourceDeviceConfigurationState the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationState> patchAsync(@Nonnull final DeviceConfigurationState sourceDeviceConfigurationState) {
        return sendAsync(HttpMethod.PATCH, sourceDeviceConfigurationState);
    }

    /**
     * Patches this DeviceConfigurationState with a source
     *
     * @param sourceDeviceConfigurationState the source object with updates
     * @return the updated DeviceConfigurationState
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationState patch(@Nonnull final DeviceConfigurationState sourceDeviceConfigurationState) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceConfigurationState);
    }

    /**
     * Creates a DeviceConfigurationState with a new object
     *
     * @param newDeviceConfigurationState the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationState> postAsync(@Nonnull final DeviceConfigurationState newDeviceConfigurationState) {
        return sendAsync(HttpMethod.POST, newDeviceConfigurationState);
    }

    /**
     * Creates a DeviceConfigurationState with a new object
     *
     * @param newDeviceConfigurationState the new object to create
     * @return the created DeviceConfigurationState
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationState post(@Nonnull final DeviceConfigurationState newDeviceConfigurationState) throws ClientException {
        return send(HttpMethod.POST, newDeviceConfigurationState);
    }

    /**
     * Creates a DeviceConfigurationState with a new object
     *
     * @param newDeviceConfigurationState the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DeviceConfigurationState> putAsync(@Nonnull final DeviceConfigurationState newDeviceConfigurationState) {
        return sendAsync(HttpMethod.PUT, newDeviceConfigurationState);
    }

    /**
     * Creates a DeviceConfigurationState with a new object
     *
     * @param newDeviceConfigurationState the object to create/update
     * @return the created DeviceConfigurationState
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DeviceConfigurationState put(@Nonnull final DeviceConfigurationState newDeviceConfigurationState) throws ClientException {
        return send(HttpMethod.PUT, newDeviceConfigurationState);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationStateRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DeviceConfigurationStateRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

