// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DomainDnsMxRecord;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain Dns Mx Record Request.
 */
public class DomainDnsMxRecordRequest extends BaseRequest<DomainDnsMxRecord> {
	
    /**
     * The request for the DomainDnsMxRecord
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DomainDnsMxRecordRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DomainDnsMxRecord.class);
    }

    /**
     * Gets the DomainDnsMxRecord from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DomainDnsMxRecord> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the DomainDnsMxRecord from the service
     *
     * @return the DomainDnsMxRecord from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DomainDnsMxRecord get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DomainDnsMxRecord> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public DomainDnsMxRecord delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DomainDnsMxRecord with a source
     *
     * @param sourceDomainDnsMxRecord the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DomainDnsMxRecord> patchAsync(@Nonnull final DomainDnsMxRecord sourceDomainDnsMxRecord) {
        return sendAsync(HttpMethod.PATCH, sourceDomainDnsMxRecord);
    }

    /**
     * Patches this DomainDnsMxRecord with a source
     *
     * @param sourceDomainDnsMxRecord the source object with updates
     * @return the updated DomainDnsMxRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DomainDnsMxRecord patch(@Nonnull final DomainDnsMxRecord sourceDomainDnsMxRecord) throws ClientException {
        return send(HttpMethod.PATCH, sourceDomainDnsMxRecord);
    }

    /**
     * Creates a DomainDnsMxRecord with a new object
     *
     * @param newDomainDnsMxRecord the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DomainDnsMxRecord> postAsync(@Nonnull final DomainDnsMxRecord newDomainDnsMxRecord) {
        return sendAsync(HttpMethod.POST, newDomainDnsMxRecord);
    }

    /**
     * Creates a DomainDnsMxRecord with a new object
     *
     * @param newDomainDnsMxRecord the new object to create
     * @return the created DomainDnsMxRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DomainDnsMxRecord post(@Nonnull final DomainDnsMxRecord newDomainDnsMxRecord) throws ClientException {
        return send(HttpMethod.POST, newDomainDnsMxRecord);
    }

    /**
     * Creates a DomainDnsMxRecord with a new object
     *
     * @param newDomainDnsMxRecord the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<DomainDnsMxRecord> putAsync(@Nonnull final DomainDnsMxRecord newDomainDnsMxRecord) {
        return sendAsync(HttpMethod.PUT, newDomainDnsMxRecord);
    }

    /**
     * Creates a DomainDnsMxRecord with a new object
     *
     * @param newDomainDnsMxRecord the object to create/update
     * @return the created DomainDnsMxRecord
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public DomainDnsMxRecord put(@Nonnull final DomainDnsMxRecord newDomainDnsMxRecord) throws ClientException {
        return send(HttpMethod.PUT, newDomainDnsMxRecord);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public DomainDnsMxRecordRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public DomainDnsMxRecordRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

