// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationRubricOutcome;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Rubric Outcome Request.
 */
public class EducationRubricOutcomeRequest extends BaseRequest<EducationRubricOutcome> {
	
    /**
     * The request for the EducationRubricOutcome
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationRubricOutcomeRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationRubricOutcome.class);
    }

    /**
     * Gets the EducationRubricOutcome from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubricOutcome> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationRubricOutcome from the service
     *
     * @return the EducationRubricOutcome from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRubricOutcome get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubricOutcome> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationRubricOutcome delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationRubricOutcome with a source
     *
     * @param sourceEducationRubricOutcome the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubricOutcome> patchAsync(@Nonnull final EducationRubricOutcome sourceEducationRubricOutcome) {
        return sendAsync(HttpMethod.PATCH, sourceEducationRubricOutcome);
    }

    /**
     * Patches this EducationRubricOutcome with a source
     *
     * @param sourceEducationRubricOutcome the source object with updates
     * @return the updated EducationRubricOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRubricOutcome patch(@Nonnull final EducationRubricOutcome sourceEducationRubricOutcome) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationRubricOutcome);
    }

    /**
     * Creates a EducationRubricOutcome with a new object
     *
     * @param newEducationRubricOutcome the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubricOutcome> postAsync(@Nonnull final EducationRubricOutcome newEducationRubricOutcome) {
        return sendAsync(HttpMethod.POST, newEducationRubricOutcome);
    }

    /**
     * Creates a EducationRubricOutcome with a new object
     *
     * @param newEducationRubricOutcome the new object to create
     * @return the created EducationRubricOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRubricOutcome post(@Nonnull final EducationRubricOutcome newEducationRubricOutcome) throws ClientException {
        return send(HttpMethod.POST, newEducationRubricOutcome);
    }

    /**
     * Creates a EducationRubricOutcome with a new object
     *
     * @param newEducationRubricOutcome the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationRubricOutcome> putAsync(@Nonnull final EducationRubricOutcome newEducationRubricOutcome) {
        return sendAsync(HttpMethod.PUT, newEducationRubricOutcome);
    }

    /**
     * Creates a EducationRubricOutcome with a new object
     *
     * @param newEducationRubricOutcome the object to create/update
     * @return the created EducationRubricOutcome
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationRubricOutcome put(@Nonnull final EducationRubricOutcome newEducationRubricOutcome) throws ClientException {
        return send(HttpMethod.PUT, newEducationRubricOutcome);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationRubricOutcomeRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationRubricOutcomeRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

