// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.EducationSubmissionResource;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Education Submission Resource Request.
 */
public class EducationSubmissionResourceRequest extends BaseRequest<EducationSubmissionResource> {
	
    /**
     * The request for the EducationSubmissionResource
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EducationSubmissionResourceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationSubmissionResource.class);
    }

    /**
     * Gets the EducationSubmissionResource from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmissionResource> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EducationSubmissionResource from the service
     *
     * @return the EducationSubmissionResource from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationSubmissionResource get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmissionResource> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EducationSubmissionResource delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EducationSubmissionResource with a source
     *
     * @param sourceEducationSubmissionResource the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmissionResource> patchAsync(@Nonnull final EducationSubmissionResource sourceEducationSubmissionResource) {
        return sendAsync(HttpMethod.PATCH, sourceEducationSubmissionResource);
    }

    /**
     * Patches this EducationSubmissionResource with a source
     *
     * @param sourceEducationSubmissionResource the source object with updates
     * @return the updated EducationSubmissionResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationSubmissionResource patch(@Nonnull final EducationSubmissionResource sourceEducationSubmissionResource) throws ClientException {
        return send(HttpMethod.PATCH, sourceEducationSubmissionResource);
    }

    /**
     * Creates a EducationSubmissionResource with a new object
     *
     * @param newEducationSubmissionResource the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmissionResource> postAsync(@Nonnull final EducationSubmissionResource newEducationSubmissionResource) {
        return sendAsync(HttpMethod.POST, newEducationSubmissionResource);
    }

    /**
     * Creates a EducationSubmissionResource with a new object
     *
     * @param newEducationSubmissionResource the new object to create
     * @return the created EducationSubmissionResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationSubmissionResource post(@Nonnull final EducationSubmissionResource newEducationSubmissionResource) throws ClientException {
        return send(HttpMethod.POST, newEducationSubmissionResource);
    }

    /**
     * Creates a EducationSubmissionResource with a new object
     *
     * @param newEducationSubmissionResource the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EducationSubmissionResource> putAsync(@Nonnull final EducationSubmissionResource newEducationSubmissionResource) {
        return sendAsync(HttpMethod.PUT, newEducationSubmissionResource);
    }

    /**
     * Creates a EducationSubmissionResource with a new object
     *
     * @param newEducationSubmissionResource the object to create/update
     * @return the created EducationSubmissionResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EducationSubmissionResource put(@Nonnull final EducationSubmissionResource newEducationSubmissionResource) throws ClientException {
        return send(HttpMethod.PUT, newEducationSubmissionResource);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EducationSubmissionResourceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EducationSubmissionResourceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

