// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.FederatedIdentityCredential;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Federated Identity Credential Request.
 */
public class FederatedIdentityCredentialRequest extends BaseRequest<FederatedIdentityCredential> {
	
    /**
     * The request for the FederatedIdentityCredential
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public FederatedIdentityCredentialRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, FederatedIdentityCredential.class);
    }

    /**
     * Gets the FederatedIdentityCredential from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FederatedIdentityCredential> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the FederatedIdentityCredential from the service
     *
     * @return the FederatedIdentityCredential from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FederatedIdentityCredential get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FederatedIdentityCredential> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public FederatedIdentityCredential delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this FederatedIdentityCredential with a source
     *
     * @param sourceFederatedIdentityCredential the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FederatedIdentityCredential> patchAsync(@Nonnull final FederatedIdentityCredential sourceFederatedIdentityCredential) {
        return sendAsync(HttpMethod.PATCH, sourceFederatedIdentityCredential);
    }

    /**
     * Patches this FederatedIdentityCredential with a source
     *
     * @param sourceFederatedIdentityCredential the source object with updates
     * @return the updated FederatedIdentityCredential
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FederatedIdentityCredential patch(@Nonnull final FederatedIdentityCredential sourceFederatedIdentityCredential) throws ClientException {
        return send(HttpMethod.PATCH, sourceFederatedIdentityCredential);
    }

    /**
     * Creates a FederatedIdentityCredential with a new object
     *
     * @param newFederatedIdentityCredential the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FederatedIdentityCredential> postAsync(@Nonnull final FederatedIdentityCredential newFederatedIdentityCredential) {
        return sendAsync(HttpMethod.POST, newFederatedIdentityCredential);
    }

    /**
     * Creates a FederatedIdentityCredential with a new object
     *
     * @param newFederatedIdentityCredential the new object to create
     * @return the created FederatedIdentityCredential
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FederatedIdentityCredential post(@Nonnull final FederatedIdentityCredential newFederatedIdentityCredential) throws ClientException {
        return send(HttpMethod.POST, newFederatedIdentityCredential);
    }

    /**
     * Creates a FederatedIdentityCredential with a new object
     *
     * @param newFederatedIdentityCredential the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FederatedIdentityCredential> putAsync(@Nonnull final FederatedIdentityCredential newFederatedIdentityCredential) {
        return sendAsync(HttpMethod.PUT, newFederatedIdentityCredential);
    }

    /**
     * Creates a FederatedIdentityCredential with a new object
     *
     * @param newFederatedIdentityCredential the object to create/update
     * @return the created FederatedIdentityCredential
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FederatedIdentityCredential put(@Nonnull final FederatedIdentityCredential newFederatedIdentityCredential) throws ClientException {
        return send(HttpMethod.PUT, newFederatedIdentityCredential);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public FederatedIdentityCredentialRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public FederatedIdentityCredentialRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

