// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.FilterOperatorSchema;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Filter Operator Schema Request.
 */
public class FilterOperatorSchemaRequest extends BaseRequest<FilterOperatorSchema> {
	
    /**
     * The request for the FilterOperatorSchema
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public FilterOperatorSchemaRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, FilterOperatorSchema.class);
    }

    /**
     * Gets the FilterOperatorSchema from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FilterOperatorSchema> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the FilterOperatorSchema from the service
     *
     * @return the FilterOperatorSchema from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FilterOperatorSchema get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FilterOperatorSchema> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public FilterOperatorSchema delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this FilterOperatorSchema with a source
     *
     * @param sourceFilterOperatorSchema the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FilterOperatorSchema> patchAsync(@Nonnull final FilterOperatorSchema sourceFilterOperatorSchema) {
        return sendAsync(HttpMethod.PATCH, sourceFilterOperatorSchema);
    }

    /**
     * Patches this FilterOperatorSchema with a source
     *
     * @param sourceFilterOperatorSchema the source object with updates
     * @return the updated FilterOperatorSchema
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FilterOperatorSchema patch(@Nonnull final FilterOperatorSchema sourceFilterOperatorSchema) throws ClientException {
        return send(HttpMethod.PATCH, sourceFilterOperatorSchema);
    }

    /**
     * Creates a FilterOperatorSchema with a new object
     *
     * @param newFilterOperatorSchema the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FilterOperatorSchema> postAsync(@Nonnull final FilterOperatorSchema newFilterOperatorSchema) {
        return sendAsync(HttpMethod.POST, newFilterOperatorSchema);
    }

    /**
     * Creates a FilterOperatorSchema with a new object
     *
     * @param newFilterOperatorSchema the new object to create
     * @return the created FilterOperatorSchema
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FilterOperatorSchema post(@Nonnull final FilterOperatorSchema newFilterOperatorSchema) throws ClientException {
        return send(HttpMethod.POST, newFilterOperatorSchema);
    }

    /**
     * Creates a FilterOperatorSchema with a new object
     *
     * @param newFilterOperatorSchema the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<FilterOperatorSchema> putAsync(@Nonnull final FilterOperatorSchema newFilterOperatorSchema) {
        return sendAsync(HttpMethod.PUT, newFilterOperatorSchema);
    }

    /**
     * Creates a FilterOperatorSchema with a new object
     *
     * @param newFilterOperatorSchema the object to create/update
     * @return the created FilterOperatorSchema
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public FilterOperatorSchema put(@Nonnull final FilterOperatorSchema newFilterOperatorSchema) throws ClientException {
        return send(HttpMethod.PUT, newFilterOperatorSchema);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public FilterOperatorSchemaRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public FilterOperatorSchemaRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

