// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.GovernanceInsight;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Governance Insight Request.
 */
public class GovernanceInsightRequest extends BaseRequest<GovernanceInsight> {
	
    /**
     * The request for the GovernanceInsight
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public GovernanceInsightRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends GovernanceInsight> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the GovernanceInsight
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public GovernanceInsightRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, GovernanceInsight.class);
    }

    /**
     * Gets the GovernanceInsight from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GovernanceInsight> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the GovernanceInsight from the service
     *
     * @return the GovernanceInsight from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public GovernanceInsight get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GovernanceInsight> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public GovernanceInsight delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this GovernanceInsight with a source
     *
     * @param sourceGovernanceInsight the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GovernanceInsight> patchAsync(@Nonnull final GovernanceInsight sourceGovernanceInsight) {
        return sendAsync(HttpMethod.PATCH, sourceGovernanceInsight);
    }

    /**
     * Patches this GovernanceInsight with a source
     *
     * @param sourceGovernanceInsight the source object with updates
     * @return the updated GovernanceInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public GovernanceInsight patch(@Nonnull final GovernanceInsight sourceGovernanceInsight) throws ClientException {
        return send(HttpMethod.PATCH, sourceGovernanceInsight);
    }

    /**
     * Creates a GovernanceInsight with a new object
     *
     * @param newGovernanceInsight the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GovernanceInsight> postAsync(@Nonnull final GovernanceInsight newGovernanceInsight) {
        return sendAsync(HttpMethod.POST, newGovernanceInsight);
    }

    /**
     * Creates a GovernanceInsight with a new object
     *
     * @param newGovernanceInsight the new object to create
     * @return the created GovernanceInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public GovernanceInsight post(@Nonnull final GovernanceInsight newGovernanceInsight) throws ClientException {
        return send(HttpMethod.POST, newGovernanceInsight);
    }

    /**
     * Creates a GovernanceInsight with a new object
     *
     * @param newGovernanceInsight the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<GovernanceInsight> putAsync(@Nonnull final GovernanceInsight newGovernanceInsight) {
        return sendAsync(HttpMethod.PUT, newGovernanceInsight);
    }

    /**
     * Creates a GovernanceInsight with a new object
     *
     * @param newGovernanceInsight the object to create/update
     * @return the created GovernanceInsight
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public GovernanceInsight put(@Nonnull final GovernanceInsight newGovernanceInsight) throws ClientException {
        return send(HttpMethod.PUT, newGovernanceInsight);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public GovernanceInsightRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public GovernanceInsightRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

