// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IdentityUserFlow;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity User Flow Request.
 */
public class IdentityUserFlowRequest extends BaseRequest<IdentityUserFlow> {
	
    /**
     * The request for the IdentityUserFlow
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public IdentityUserFlowRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends IdentityUserFlow> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the IdentityUserFlow
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IdentityUserFlowRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityUserFlow.class);
    }

    /**
     * Gets the IdentityUserFlow from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlow> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IdentityUserFlow from the service
     *
     * @return the IdentityUserFlow from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityUserFlow get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlow> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IdentityUserFlow delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IdentityUserFlow with a source
     *
     * @param sourceIdentityUserFlow the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlow> patchAsync(@Nonnull final IdentityUserFlow sourceIdentityUserFlow) {
        return sendAsync(HttpMethod.PATCH, sourceIdentityUserFlow);
    }

    /**
     * Patches this IdentityUserFlow with a source
     *
     * @param sourceIdentityUserFlow the source object with updates
     * @return the updated IdentityUserFlow
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityUserFlow patch(@Nonnull final IdentityUserFlow sourceIdentityUserFlow) throws ClientException {
        return send(HttpMethod.PATCH, sourceIdentityUserFlow);
    }

    /**
     * Creates a IdentityUserFlow with a new object
     *
     * @param newIdentityUserFlow the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlow> postAsync(@Nonnull final IdentityUserFlow newIdentityUserFlow) {
        return sendAsync(HttpMethod.POST, newIdentityUserFlow);
    }

    /**
     * Creates a IdentityUserFlow with a new object
     *
     * @param newIdentityUserFlow the new object to create
     * @return the created IdentityUserFlow
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityUserFlow post(@Nonnull final IdentityUserFlow newIdentityUserFlow) throws ClientException {
        return send(HttpMethod.POST, newIdentityUserFlow);
    }

    /**
     * Creates a IdentityUserFlow with a new object
     *
     * @param newIdentityUserFlow the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IdentityUserFlow> putAsync(@Nonnull final IdentityUserFlow newIdentityUserFlow) {
        return sendAsync(HttpMethod.PUT, newIdentityUserFlow);
    }

    /**
     * Creates a IdentityUserFlow with a new object
     *
     * @param newIdentityUserFlow the object to create/update
     * @return the created IdentityUserFlow
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IdentityUserFlow put(@Nonnull final IdentityUserFlow newIdentityUserFlow) throws ClientException {
        return send(HttpMethod.PUT, newIdentityUserFlow);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IdentityUserFlowRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IdentityUserFlowRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

