// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.IosLobApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Lob App Request.
 */
public class IosLobAppRequest extends BaseRequest<IosLobApp> {
	
    /**
     * The request for the IosLobApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IosLobAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, IosLobApp.class);
    }

    /**
     * Gets the IosLobApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosLobApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the IosLobApp from the service
     *
     * @return the IosLobApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosLobApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosLobApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public IosLobApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this IosLobApp with a source
     *
     * @param sourceIosLobApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosLobApp> patchAsync(@Nonnull final IosLobApp sourceIosLobApp) {
        return sendAsync(HttpMethod.PATCH, sourceIosLobApp);
    }

    /**
     * Patches this IosLobApp with a source
     *
     * @param sourceIosLobApp the source object with updates
     * @return the updated IosLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosLobApp patch(@Nonnull final IosLobApp sourceIosLobApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceIosLobApp);
    }

    /**
     * Creates a IosLobApp with a new object
     *
     * @param newIosLobApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosLobApp> postAsync(@Nonnull final IosLobApp newIosLobApp) {
        return sendAsync(HttpMethod.POST, newIosLobApp);
    }

    /**
     * Creates a IosLobApp with a new object
     *
     * @param newIosLobApp the new object to create
     * @return the created IosLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosLobApp post(@Nonnull final IosLobApp newIosLobApp) throws ClientException {
        return send(HttpMethod.POST, newIosLobApp);
    }

    /**
     * Creates a IosLobApp with a new object
     *
     * @param newIosLobApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<IosLobApp> putAsync(@Nonnull final IosLobApp newIosLobApp) {
        return sendAsync(HttpMethod.PUT, newIosLobApp);
    }

    /**
     * Creates a IosLobApp with a new object
     *
     * @param newIosLobApp the object to create/update
     * @return the created IosLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public IosLobApp put(@Nonnull final IosLobApp newIosLobApp) throws ClientException {
        return send(HttpMethod.PUT, newIosLobApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IosLobAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IosLobAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

