// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LinkedResource;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Linked Resource Request.
 */
public class LinkedResourceRequest extends BaseRequest<LinkedResource> {
	
    /**
     * The request for the LinkedResource
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LinkedResourceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LinkedResource.class);
    }

    /**
     * Gets the LinkedResource from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LinkedResource> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LinkedResource from the service
     *
     * @return the LinkedResource from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LinkedResource get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LinkedResource> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LinkedResource delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LinkedResource with a source
     *
     * @param sourceLinkedResource the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LinkedResource> patchAsync(@Nonnull final LinkedResource sourceLinkedResource) {
        return sendAsync(HttpMethod.PATCH, sourceLinkedResource);
    }

    /**
     * Patches this LinkedResource with a source
     *
     * @param sourceLinkedResource the source object with updates
     * @return the updated LinkedResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LinkedResource patch(@Nonnull final LinkedResource sourceLinkedResource) throws ClientException {
        return send(HttpMethod.PATCH, sourceLinkedResource);
    }

    /**
     * Creates a LinkedResource with a new object
     *
     * @param newLinkedResource the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LinkedResource> postAsync(@Nonnull final LinkedResource newLinkedResource) {
        return sendAsync(HttpMethod.POST, newLinkedResource);
    }

    /**
     * Creates a LinkedResource with a new object
     *
     * @param newLinkedResource the new object to create
     * @return the created LinkedResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LinkedResource post(@Nonnull final LinkedResource newLinkedResource) throws ClientException {
        return send(HttpMethod.POST, newLinkedResource);
    }

    /**
     * Creates a LinkedResource with a new object
     *
     * @param newLinkedResource the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LinkedResource> putAsync(@Nonnull final LinkedResource newLinkedResource) {
        return sendAsync(HttpMethod.PUT, newLinkedResource);
    }

    /**
     * Creates a LinkedResource with a new object
     *
     * @param newLinkedResource the object to create/update
     * @return the created LinkedResource
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LinkedResource put(@Nonnull final LinkedResource newLinkedResource) throws ClientException {
        return send(HttpMethod.PUT, newLinkedResource);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LinkedResourceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LinkedResourceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

