// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MacOSMicrosoftDefenderApp;
import com.microsoft.graph.models.MobileAppAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mac OSMicrosoft Defender App Request.
 */
public class MacOSMicrosoftDefenderAppRequest extends BaseRequest<MacOSMicrosoftDefenderApp> {
	
    /**
     * The request for the MacOSMicrosoftDefenderApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MacOSMicrosoftDefenderAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MacOSMicrosoftDefenderApp.class);
    }

    /**
     * Gets the MacOSMicrosoftDefenderApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSMicrosoftDefenderApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MacOSMicrosoftDefenderApp from the service
     *
     * @return the MacOSMicrosoftDefenderApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSMicrosoftDefenderApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSMicrosoftDefenderApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MacOSMicrosoftDefenderApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MacOSMicrosoftDefenderApp with a source
     *
     * @param sourceMacOSMicrosoftDefenderApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSMicrosoftDefenderApp> patchAsync(@Nonnull final MacOSMicrosoftDefenderApp sourceMacOSMicrosoftDefenderApp) {
        return sendAsync(HttpMethod.PATCH, sourceMacOSMicrosoftDefenderApp);
    }

    /**
     * Patches this MacOSMicrosoftDefenderApp with a source
     *
     * @param sourceMacOSMicrosoftDefenderApp the source object with updates
     * @return the updated MacOSMicrosoftDefenderApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSMicrosoftDefenderApp patch(@Nonnull final MacOSMicrosoftDefenderApp sourceMacOSMicrosoftDefenderApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceMacOSMicrosoftDefenderApp);
    }

    /**
     * Creates a MacOSMicrosoftDefenderApp with a new object
     *
     * @param newMacOSMicrosoftDefenderApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSMicrosoftDefenderApp> postAsync(@Nonnull final MacOSMicrosoftDefenderApp newMacOSMicrosoftDefenderApp) {
        return sendAsync(HttpMethod.POST, newMacOSMicrosoftDefenderApp);
    }

    /**
     * Creates a MacOSMicrosoftDefenderApp with a new object
     *
     * @param newMacOSMicrosoftDefenderApp the new object to create
     * @return the created MacOSMicrosoftDefenderApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSMicrosoftDefenderApp post(@Nonnull final MacOSMicrosoftDefenderApp newMacOSMicrosoftDefenderApp) throws ClientException {
        return send(HttpMethod.POST, newMacOSMicrosoftDefenderApp);
    }

    /**
     * Creates a MacOSMicrosoftDefenderApp with a new object
     *
     * @param newMacOSMicrosoftDefenderApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MacOSMicrosoftDefenderApp> putAsync(@Nonnull final MacOSMicrosoftDefenderApp newMacOSMicrosoftDefenderApp) {
        return sendAsync(HttpMethod.PUT, newMacOSMicrosoftDefenderApp);
    }

    /**
     * Creates a MacOSMicrosoftDefenderApp with a new object
     *
     * @param newMacOSMicrosoftDefenderApp the object to create/update
     * @return the created MacOSMicrosoftDefenderApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MacOSMicrosoftDefenderApp put(@Nonnull final MacOSMicrosoftDefenderApp newMacOSMicrosoftDefenderApp) throws ClientException {
        return send(HttpMethod.PUT, newMacOSMicrosoftDefenderApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MacOSMicrosoftDefenderAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MacOSMicrosoftDefenderAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

