// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.OrganizationSetMobileDeviceManagementAuthorityRequest;
import com.microsoft.graph.models.Organization;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Organization Set Mobile Device Management Authority Request Builder.
 */
public class OrganizationSetMobileDeviceManagementAuthorityRequestBuilder extends BaseActionRequestBuilder<Integer> {

    /**
     * The request builder for this OrganizationSetMobileDeviceManagementAuthority
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OrganizationSetMobileDeviceManagementAuthorityRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the OrganizationSetMobileDeviceManagementAuthorityRequest
     *
     * @param requestOptions the options for the request
     * @return the OrganizationSetMobileDeviceManagementAuthorityRequest instance
     */
    @Nonnull
    public OrganizationSetMobileDeviceManagementAuthorityRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the OrganizationSetMobileDeviceManagementAuthorityRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the OrganizationSetMobileDeviceManagementAuthorityRequest instance
     */
    @Nonnull
    public OrganizationSetMobileDeviceManagementAuthorityRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final OrganizationSetMobileDeviceManagementAuthorityRequest request = new OrganizationSetMobileDeviceManagementAuthorityRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
