// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.ParticipantStartHoldMusicRequest;
import com.microsoft.graph.models.Participant;
import com.microsoft.graph.models.Prompt;
import com.microsoft.graph.models.StartHoldMusicOperation;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.ParticipantStartHoldMusicParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Participant Start Hold Music Request Builder.
 */
public class ParticipantStartHoldMusicRequestBuilder extends BaseActionRequestBuilder<StartHoldMusicOperation> {

    /**
     * The request builder for this ParticipantStartHoldMusic
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ParticipantStartHoldMusicRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private ParticipantStartHoldMusicParameterSet body;
    /**
     * The request builder for this ParticipantStartHoldMusic
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ParticipantStartHoldMusicRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ParticipantStartHoldMusicParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the ParticipantStartHoldMusicRequest
     *
     * @param requestOptions the options for the request
     * @return the ParticipantStartHoldMusicRequest instance
     */
    @Nonnull
    public ParticipantStartHoldMusicRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the ParticipantStartHoldMusicRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ParticipantStartHoldMusicRequest instance
     */
    @Nonnull
    public ParticipantStartHoldMusicRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ParticipantStartHoldMusicRequest request = new ParticipantStartHoldMusicRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
