// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PhoneAuthenticationMethod;
import com.microsoft.graph.models.PasswordResetResponse;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Phone Authentication Method Request.
 */
public class PhoneAuthenticationMethodRequest extends BaseRequest<PhoneAuthenticationMethod> {
	
    /**
     * The request for the PhoneAuthenticationMethod
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PhoneAuthenticationMethodRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PhoneAuthenticationMethod.class);
    }

    /**
     * Gets the PhoneAuthenticationMethod from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PhoneAuthenticationMethod> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PhoneAuthenticationMethod from the service
     *
     * @return the PhoneAuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PhoneAuthenticationMethod get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PhoneAuthenticationMethod> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PhoneAuthenticationMethod delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PhoneAuthenticationMethod with a source
     *
     * @param sourcePhoneAuthenticationMethod the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PhoneAuthenticationMethod> patchAsync(@Nonnull final PhoneAuthenticationMethod sourcePhoneAuthenticationMethod) {
        return sendAsync(HttpMethod.PATCH, sourcePhoneAuthenticationMethod);
    }

    /**
     * Patches this PhoneAuthenticationMethod with a source
     *
     * @param sourcePhoneAuthenticationMethod the source object with updates
     * @return the updated PhoneAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PhoneAuthenticationMethod patch(@Nonnull final PhoneAuthenticationMethod sourcePhoneAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PATCH, sourcePhoneAuthenticationMethod);
    }

    /**
     * Creates a PhoneAuthenticationMethod with a new object
     *
     * @param newPhoneAuthenticationMethod the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PhoneAuthenticationMethod> postAsync(@Nonnull final PhoneAuthenticationMethod newPhoneAuthenticationMethod) {
        return sendAsync(HttpMethod.POST, newPhoneAuthenticationMethod);
    }

    /**
     * Creates a PhoneAuthenticationMethod with a new object
     *
     * @param newPhoneAuthenticationMethod the new object to create
     * @return the created PhoneAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PhoneAuthenticationMethod post(@Nonnull final PhoneAuthenticationMethod newPhoneAuthenticationMethod) throws ClientException {
        return send(HttpMethod.POST, newPhoneAuthenticationMethod);
    }

    /**
     * Creates a PhoneAuthenticationMethod with a new object
     *
     * @param newPhoneAuthenticationMethod the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PhoneAuthenticationMethod> putAsync(@Nonnull final PhoneAuthenticationMethod newPhoneAuthenticationMethod) {
        return sendAsync(HttpMethod.PUT, newPhoneAuthenticationMethod);
    }

    /**
     * Creates a PhoneAuthenticationMethod with a new object
     *
     * @param newPhoneAuthenticationMethod the object to create/update
     * @return the created PhoneAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PhoneAuthenticationMethod put(@Nonnull final PhoneAuthenticationMethod newPhoneAuthenticationMethod) throws ClientException {
        return send(HttpMethod.PUT, newPhoneAuthenticationMethod);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PhoneAuthenticationMethodRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PhoneAuthenticationMethodRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

