// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Place;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Place Request.
 */
public class PlaceRequest extends BaseRequest<Place> {
	
    /**
     * The request for the Place
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public PlaceRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends Place> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the Place
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PlaceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Place.class);
    }

    /**
     * Gets the Place from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Place> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Place from the service
     *
     * @return the Place from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Place get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Place> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Place delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Place with a source
     *
     * @param sourcePlace the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Place> patchAsync(@Nonnull final Place sourcePlace) {
        return sendAsync(HttpMethod.PATCH, sourcePlace);
    }

    /**
     * Patches this Place with a source
     *
     * @param sourcePlace the source object with updates
     * @return the updated Place
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Place patch(@Nonnull final Place sourcePlace) throws ClientException {
        return send(HttpMethod.PATCH, sourcePlace);
    }

    /**
     * Creates a Place with a new object
     *
     * @param newPlace the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Place> postAsync(@Nonnull final Place newPlace) {
        return sendAsync(HttpMethod.POST, newPlace);
    }

    /**
     * Creates a Place with a new object
     *
     * @param newPlace the new object to create
     * @return the created Place
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Place post(@Nonnull final Place newPlace) throws ClientException {
        return send(HttpMethod.POST, newPlace);
    }

    /**
     * Creates a Place with a new object
     *
     * @param newPlace the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Place> putAsync(@Nonnull final Place newPlace) {
        return sendAsync(HttpMethod.PUT, newPlace);
    }

    /**
     * Creates a Place with a new object
     *
     * @param newPlace the object to create/update
     * @return the created Place
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Place put(@Nonnull final Place newPlace) throws ClientException {
        return send(HttpMethod.PUT, newPlace);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PlaceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PlaceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

