// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.PrintDocumentCreateUploadSessionRequest;
import com.microsoft.graph.models.PrintDocument;
import com.microsoft.graph.models.PrintDocumentUploadProperties;
import com.microsoft.graph.models.UploadSession;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.PrintDocumentCreateUploadSessionParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Print Document Create Upload Session Request Builder.
 */
public class PrintDocumentCreateUploadSessionRequestBuilder extends BaseActionRequestBuilder<UploadSession> {

    /**
     * The request builder for this PrintDocumentCreateUploadSession
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrintDocumentCreateUploadSessionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private PrintDocumentCreateUploadSessionParameterSet body;
    /**
     * The request builder for this PrintDocumentCreateUploadSession
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public PrintDocumentCreateUploadSessionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final PrintDocumentCreateUploadSessionParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the PrintDocumentCreateUploadSessionRequest
     *
     * @param requestOptions the options for the request
     * @return the PrintDocumentCreateUploadSessionRequest instance
     */
    @Nonnull
    public PrintDocumentCreateUploadSessionRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the PrintDocumentCreateUploadSessionRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the PrintDocumentCreateUploadSessionRequest instance
     */
    @Nonnull
    public PrintDocumentCreateUploadSessionRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final PrintDocumentCreateUploadSessionRequest request = new PrintDocumentCreateUploadSessionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
