// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RiskDetection;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risk Detection Request.
 */
public class RiskDetectionRequest extends BaseRequest<RiskDetection> {
	
    /**
     * The request for the RiskDetection
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RiskDetectionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, RiskDetection.class);
    }

    /**
     * Gets the RiskDetection from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskDetection> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the RiskDetection from the service
     *
     * @return the RiskDetection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskDetection get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskDetection> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public RiskDetection delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this RiskDetection with a source
     *
     * @param sourceRiskDetection the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskDetection> patchAsync(@Nonnull final RiskDetection sourceRiskDetection) {
        return sendAsync(HttpMethod.PATCH, sourceRiskDetection);
    }

    /**
     * Patches this RiskDetection with a source
     *
     * @param sourceRiskDetection the source object with updates
     * @return the updated RiskDetection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskDetection patch(@Nonnull final RiskDetection sourceRiskDetection) throws ClientException {
        return send(HttpMethod.PATCH, sourceRiskDetection);
    }

    /**
     * Creates a RiskDetection with a new object
     *
     * @param newRiskDetection the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskDetection> postAsync(@Nonnull final RiskDetection newRiskDetection) {
        return sendAsync(HttpMethod.POST, newRiskDetection);
    }

    /**
     * Creates a RiskDetection with a new object
     *
     * @param newRiskDetection the new object to create
     * @return the created RiskDetection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskDetection post(@Nonnull final RiskDetection newRiskDetection) throws ClientException {
        return send(HttpMethod.POST, newRiskDetection);
    }

    /**
     * Creates a RiskDetection with a new object
     *
     * @param newRiskDetection the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskDetection> putAsync(@Nonnull final RiskDetection newRiskDetection) {
        return sendAsync(HttpMethod.PUT, newRiskDetection);
    }

    /**
     * Creates a RiskDetection with a new object
     *
     * @param newRiskDetection the object to create/update
     * @return the created RiskDetection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskDetection put(@Nonnull final RiskDetection newRiskDetection) throws ClientException {
        return send(HttpMethod.PUT, newRiskDetection);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public RiskDetectionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public RiskDetectionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

