// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RiskyServicePrincipal;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Risky Service Principal Request.
 */
public class RiskyServicePrincipalRequest extends BaseRequest<RiskyServicePrincipal> {
	
    /**
     * The request for the RiskyServicePrincipal
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public RiskyServicePrincipalRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends RiskyServicePrincipal> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the RiskyServicePrincipal
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RiskyServicePrincipalRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, RiskyServicePrincipal.class);
    }

    /**
     * Gets the RiskyServicePrincipal from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipal> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the RiskyServicePrincipal from the service
     *
     * @return the RiskyServicePrincipal from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskyServicePrincipal get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipal> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public RiskyServicePrincipal delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this RiskyServicePrincipal with a source
     *
     * @param sourceRiskyServicePrincipal the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipal> patchAsync(@Nonnull final RiskyServicePrincipal sourceRiskyServicePrincipal) {
        return sendAsync(HttpMethod.PATCH, sourceRiskyServicePrincipal);
    }

    /**
     * Patches this RiskyServicePrincipal with a source
     *
     * @param sourceRiskyServicePrincipal the source object with updates
     * @return the updated RiskyServicePrincipal
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskyServicePrincipal patch(@Nonnull final RiskyServicePrincipal sourceRiskyServicePrincipal) throws ClientException {
        return send(HttpMethod.PATCH, sourceRiskyServicePrincipal);
    }

    /**
     * Creates a RiskyServicePrincipal with a new object
     *
     * @param newRiskyServicePrincipal the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipal> postAsync(@Nonnull final RiskyServicePrincipal newRiskyServicePrincipal) {
        return sendAsync(HttpMethod.POST, newRiskyServicePrincipal);
    }

    /**
     * Creates a RiskyServicePrincipal with a new object
     *
     * @param newRiskyServicePrincipal the new object to create
     * @return the created RiskyServicePrincipal
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskyServicePrincipal post(@Nonnull final RiskyServicePrincipal newRiskyServicePrincipal) throws ClientException {
        return send(HttpMethod.POST, newRiskyServicePrincipal);
    }

    /**
     * Creates a RiskyServicePrincipal with a new object
     *
     * @param newRiskyServicePrincipal the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<RiskyServicePrincipal> putAsync(@Nonnull final RiskyServicePrincipal newRiskyServicePrincipal) {
        return sendAsync(HttpMethod.PUT, newRiskyServicePrincipal);
    }

    /**
     * Creates a RiskyServicePrincipal with a new object
     *
     * @param newRiskyServicePrincipal the object to create/update
     * @return the created RiskyServicePrincipal
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public RiskyServicePrincipal put(@Nonnull final RiskyServicePrincipal newRiskyServicePrincipal) throws ClientException {
        return send(HttpMethod.PUT, newRiskyServicePrincipal);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public RiskyServicePrincipalRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public RiskyServicePrincipalRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

