// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Sharepoint;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Sharepoint Request.
 */
public class SharepointRequest extends BaseRequest<Sharepoint> {
	
    /**
     * The request for the Sharepoint
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SharepointRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Sharepoint.class);
    }

    /**
     * Gets the Sharepoint from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Sharepoint> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Sharepoint from the service
     *
     * @return the Sharepoint from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Sharepoint get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Sharepoint> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Sharepoint delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Sharepoint with a source
     *
     * @param sourceSharepoint the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Sharepoint> patchAsync(@Nonnull final Sharepoint sourceSharepoint) {
        return sendAsync(HttpMethod.PATCH, sourceSharepoint);
    }

    /**
     * Patches this Sharepoint with a source
     *
     * @param sourceSharepoint the source object with updates
     * @return the updated Sharepoint
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Sharepoint patch(@Nonnull final Sharepoint sourceSharepoint) throws ClientException {
        return send(HttpMethod.PATCH, sourceSharepoint);
    }

    /**
     * Creates a Sharepoint with a new object
     *
     * @param newSharepoint the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Sharepoint> postAsync(@Nonnull final Sharepoint newSharepoint) {
        return sendAsync(HttpMethod.POST, newSharepoint);
    }

    /**
     * Creates a Sharepoint with a new object
     *
     * @param newSharepoint the new object to create
     * @return the created Sharepoint
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Sharepoint post(@Nonnull final Sharepoint newSharepoint) throws ClientException {
        return send(HttpMethod.POST, newSharepoint);
    }

    /**
     * Creates a Sharepoint with a new object
     *
     * @param newSharepoint the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Sharepoint> putAsync(@Nonnull final Sharepoint newSharepoint) {
        return sendAsync(HttpMethod.PUT, newSharepoint);
    }

    /**
     * Creates a Sharepoint with a new object
     *
     * @param newSharepoint the object to create/update
     * @return the created Sharepoint
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Sharepoint put(@Nonnull final Sharepoint newSharepoint) throws ClientException {
        return send(HttpMethod.PUT, newSharepoint);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SharepointRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SharepointRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

