// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SmsAuthenticationMethodConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Sms Authentication Method Configuration Request.
 */
public class SmsAuthenticationMethodConfigurationRequest extends BaseRequest<SmsAuthenticationMethodConfiguration> {
	
    /**
     * The request for the SmsAuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SmsAuthenticationMethodConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SmsAuthenticationMethodConfiguration.class);
    }

    /**
     * Gets the SmsAuthenticationMethodConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SmsAuthenticationMethodConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SmsAuthenticationMethodConfiguration from the service
     *
     * @return the SmsAuthenticationMethodConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SmsAuthenticationMethodConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SmsAuthenticationMethodConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SmsAuthenticationMethodConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SmsAuthenticationMethodConfiguration with a source
     *
     * @param sourceSmsAuthenticationMethodConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SmsAuthenticationMethodConfiguration> patchAsync(@Nonnull final SmsAuthenticationMethodConfiguration sourceSmsAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceSmsAuthenticationMethodConfiguration);
    }

    /**
     * Patches this SmsAuthenticationMethodConfiguration with a source
     *
     * @param sourceSmsAuthenticationMethodConfiguration the source object with updates
     * @return the updated SmsAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SmsAuthenticationMethodConfiguration patch(@Nonnull final SmsAuthenticationMethodConfiguration sourceSmsAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceSmsAuthenticationMethodConfiguration);
    }

    /**
     * Creates a SmsAuthenticationMethodConfiguration with a new object
     *
     * @param newSmsAuthenticationMethodConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SmsAuthenticationMethodConfiguration> postAsync(@Nonnull final SmsAuthenticationMethodConfiguration newSmsAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.POST, newSmsAuthenticationMethodConfiguration);
    }

    /**
     * Creates a SmsAuthenticationMethodConfiguration with a new object
     *
     * @param newSmsAuthenticationMethodConfiguration the new object to create
     * @return the created SmsAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SmsAuthenticationMethodConfiguration post(@Nonnull final SmsAuthenticationMethodConfiguration newSmsAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.POST, newSmsAuthenticationMethodConfiguration);
    }

    /**
     * Creates a SmsAuthenticationMethodConfiguration with a new object
     *
     * @param newSmsAuthenticationMethodConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SmsAuthenticationMethodConfiguration> putAsync(@Nonnull final SmsAuthenticationMethodConfiguration newSmsAuthenticationMethodConfiguration) {
        return sendAsync(HttpMethod.PUT, newSmsAuthenticationMethodConfiguration);
    }

    /**
     * Creates a SmsAuthenticationMethodConfiguration with a new object
     *
     * @param newSmsAuthenticationMethodConfiguration the object to create/update
     * @return the created SmsAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SmsAuthenticationMethodConfiguration put(@Nonnull final SmsAuthenticationMethodConfiguration newSmsAuthenticationMethodConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newSmsAuthenticationMethodConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SmsAuthenticationMethodConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SmsAuthenticationMethodConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

