// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SolutionsRoot;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Solutions Root Request.
 */
public class SolutionsRootRequest extends BaseRequest<SolutionsRoot> {
	
    /**
     * The request for the SolutionsRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SolutionsRootRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SolutionsRoot.class);
    }

    /**
     * Gets the SolutionsRoot from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SolutionsRoot> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SolutionsRoot from the service
     *
     * @return the SolutionsRoot from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SolutionsRoot get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SolutionsRoot> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SolutionsRoot delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SolutionsRoot with a source
     *
     * @param sourceSolutionsRoot the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SolutionsRoot> patchAsync(@Nonnull final SolutionsRoot sourceSolutionsRoot) {
        return sendAsync(HttpMethod.PATCH, sourceSolutionsRoot);
    }

    /**
     * Patches this SolutionsRoot with a source
     *
     * @param sourceSolutionsRoot the source object with updates
     * @return the updated SolutionsRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SolutionsRoot patch(@Nonnull final SolutionsRoot sourceSolutionsRoot) throws ClientException {
        return send(HttpMethod.PATCH, sourceSolutionsRoot);
    }

    /**
     * Creates a SolutionsRoot with a new object
     *
     * @param newSolutionsRoot the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SolutionsRoot> postAsync(@Nonnull final SolutionsRoot newSolutionsRoot) {
        return sendAsync(HttpMethod.POST, newSolutionsRoot);
    }

    /**
     * Creates a SolutionsRoot with a new object
     *
     * @param newSolutionsRoot the new object to create
     * @return the created SolutionsRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SolutionsRoot post(@Nonnull final SolutionsRoot newSolutionsRoot) throws ClientException {
        return send(HttpMethod.POST, newSolutionsRoot);
    }

    /**
     * Creates a SolutionsRoot with a new object
     *
     * @param newSolutionsRoot the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SolutionsRoot> putAsync(@Nonnull final SolutionsRoot newSolutionsRoot) {
        return sendAsync(HttpMethod.PUT, newSolutionsRoot);
    }

    /**
     * Creates a SolutionsRoot with a new object
     *
     * @param newSolutionsRoot the object to create/update
     * @return the created SolutionsRoot
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SolutionsRoot put(@Nonnull final SolutionsRoot newSolutionsRoot) throws ClientException {
        return send(HttpMethod.PUT, newSolutionsRoot);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SolutionsRootRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SolutionsRootRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

