// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.SynchronizationAcquireAccessTokenRequest;
import com.microsoft.graph.models.Synchronization;
import com.microsoft.graph.models.SynchronizationSecretKeyStringValuePair;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.SynchronizationAcquireAccessTokenParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Acquire Access Token Request Builder.
 */
public class SynchronizationAcquireAccessTokenRequestBuilder extends BaseActionRequestBuilder<Synchronization> {

    /**
     * The request builder for this SynchronizationAcquireAccessToken
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SynchronizationAcquireAccessTokenRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private SynchronizationAcquireAccessTokenParameterSet body;
    /**
     * The request builder for this SynchronizationAcquireAccessToken
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public SynchronizationAcquireAccessTokenRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final SynchronizationAcquireAccessTokenParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the SynchronizationAcquireAccessTokenRequest
     *
     * @param requestOptions the options for the request
     * @return the SynchronizationAcquireAccessTokenRequest instance
     */
    @Nonnull
    public SynchronizationAcquireAccessTokenRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the SynchronizationAcquireAccessTokenRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the SynchronizationAcquireAccessTokenRequest instance
     */
    @Nonnull
    public SynchronizationAcquireAccessTokenRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final SynchronizationAcquireAccessTokenRequest request = new SynchronizationAcquireAccessTokenRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
