// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SynchronizationJob;
import com.microsoft.graph.models.SynchronizationJobApplicationParameters;
import com.microsoft.graph.models.StringKeyStringValuePair;
import com.microsoft.graph.models.SynchronizationJobRestartCriteria;
import com.microsoft.graph.models.SynchronizationSecretKeyStringValuePair;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.SynchronizationJobProvisionOnDemandParameterSet;
import com.microsoft.graph.models.SynchronizationJobRestartParameterSet;
import com.microsoft.graph.models.SynchronizationJobValidateCredentialsParameterSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Job Request Builder.
 */
public class SynchronizationJobRequestBuilder extends BaseRequestBuilder<SynchronizationJob> {

    /**
     * The request builder for the SynchronizationJob
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SynchronizationJobRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the SynchronizationJobRequest instance
     */
    @Nonnull
    public SynchronizationJobRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the SynchronizationJobRequest instance
     */
    @Nonnull
    public SynchronizationJobRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.SynchronizationJobRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for SynchronizationSchema
     *
     * @return the SynchronizationSchemaRequestBuilder instance
     */
    @Nonnull
    public com.microsoft.graph.requests.SynchronizationSchemaRequestBuilder schema() {
        return new com.microsoft.graph.requests.SynchronizationSchemaRequestBuilder(getRequestUrlWithAdditionalSegment("schema"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public SynchronizationJobPauseRequestBuilder pause() {
        return new SynchronizationJobPauseRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.pause"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public SynchronizationJobProvisionOnDemandRequestBuilder provisionOnDemand(@Nonnull final SynchronizationJobProvisionOnDemandParameterSet parameters) {
        return new SynchronizationJobProvisionOnDemandRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.provisionOnDemand"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public SynchronizationJobRestartRequestBuilder restart(@Nonnull final SynchronizationJobRestartParameterSet parameters) {
        return new SynchronizationJobRestartRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.restart"), getClient(), null, parameters);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public SynchronizationJobStartRequestBuilder start() {
        return new SynchronizationJobStartRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.start"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     * @param parameters the parameters for the service method
     */
    @Nonnull
    public SynchronizationJobValidateCredentialsRequestBuilder validateCredentials(@Nonnull final SynchronizationJobValidateCredentialsParameterSet parameters) {
        return new SynchronizationJobValidateCredentialsRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.validateCredentials"), getClient(), null, parameters);
    }
}
