// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SynchronizationSchema;
import com.microsoft.graph.models.ExpressionInputObject;
import com.microsoft.graph.models.AttributeDefinition;
import com.microsoft.graph.models.ParseExpressionResponse;
import com.microsoft.graph.models.FilterOperatorSchema;
import com.microsoft.graph.models.AttributeMappingFunctionSchema;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Synchronization Schema Request.
 */
public class SynchronizationSchemaRequest extends BaseRequest<SynchronizationSchema> {
	
    /**
     * The request for the SynchronizationSchema
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SynchronizationSchemaRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SynchronizationSchema.class);
    }

    /**
     * Gets the SynchronizationSchema from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationSchema> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SynchronizationSchema from the service
     *
     * @return the SynchronizationSchema from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SynchronizationSchema get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationSchema> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SynchronizationSchema delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SynchronizationSchema with a source
     *
     * @param sourceSynchronizationSchema the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationSchema> patchAsync(@Nonnull final SynchronizationSchema sourceSynchronizationSchema) {
        return sendAsync(HttpMethod.PATCH, sourceSynchronizationSchema);
    }

    /**
     * Patches this SynchronizationSchema with a source
     *
     * @param sourceSynchronizationSchema the source object with updates
     * @return the updated SynchronizationSchema
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SynchronizationSchema patch(@Nonnull final SynchronizationSchema sourceSynchronizationSchema) throws ClientException {
        return send(HttpMethod.PATCH, sourceSynchronizationSchema);
    }

    /**
     * Creates a SynchronizationSchema with a new object
     *
     * @param newSynchronizationSchema the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationSchema> postAsync(@Nonnull final SynchronizationSchema newSynchronizationSchema) {
        return sendAsync(HttpMethod.POST, newSynchronizationSchema);
    }

    /**
     * Creates a SynchronizationSchema with a new object
     *
     * @param newSynchronizationSchema the new object to create
     * @return the created SynchronizationSchema
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SynchronizationSchema post(@Nonnull final SynchronizationSchema newSynchronizationSchema) throws ClientException {
        return send(HttpMethod.POST, newSynchronizationSchema);
    }

    /**
     * Creates a SynchronizationSchema with a new object
     *
     * @param newSynchronizationSchema the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SynchronizationSchema> putAsync(@Nonnull final SynchronizationSchema newSynchronizationSchema) {
        return sendAsync(HttpMethod.PUT, newSynchronizationSchema);
    }

    /**
     * Creates a SynchronizationSchema with a new object
     *
     * @param newSynchronizationSchema the object to create/update
     * @return the created SynchronizationSchema
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SynchronizationSchema put(@Nonnull final SynchronizationSchema newSynchronizationSchema) throws ClientException {
        return send(HttpMethod.PUT, newSynchronizationSchema);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SynchronizationSchemaRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SynchronizationSchemaRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

