// Template Source: BaseEntityCollectionRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.RbacApplication;
import com.microsoft.graph.models.UnifiedRbacResourceNamespace;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.requests.UnifiedRbacResourceNamespaceCollectionResponse;
import com.microsoft.graph.requests.UnifiedRbacResourceNamespaceCollectionRequestBuilder;
import com.microsoft.graph.requests.UnifiedRbacResourceNamespaceCollectionRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Rbac Resource Namespace Collection Request.
 */
public class UnifiedRbacResourceNamespaceCollectionRequest extends BaseEntityCollectionRequest<UnifiedRbacResourceNamespace, UnifiedRbacResourceNamespaceCollectionResponse, UnifiedRbacResourceNamespaceCollectionPage> {

    /**
     * The request builder for this collection of UnifiedRbacResourceNamespace
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRbacResourceNamespaceCollectionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRbacResourceNamespaceCollectionResponse.class, UnifiedRbacResourceNamespaceCollectionPage.class, UnifiedRbacResourceNamespaceCollectionRequestBuilder.class);
    }

    /**
     * Creates a new UnifiedRbacResourceNamespace
     * @param newUnifiedRbacResourceNamespace the UnifiedRbacResourceNamespace to create
     * @return a future with the created object
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRbacResourceNamespace> postAsync(@Nonnull final UnifiedRbacResourceNamespace newUnifiedRbacResourceNamespace) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new UnifiedRbacResourceNamespaceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .postAsync(newUnifiedRbacResourceNamespace);
    }

    /**
     * Creates a new UnifiedRbacResourceNamespace
     * @param newUnifiedRbacResourceNamespace the UnifiedRbacResourceNamespace to create
     * @return the newly created object
     */
    @Nonnull
    public UnifiedRbacResourceNamespace post(@Nonnull final UnifiedRbacResourceNamespace newUnifiedRbacResourceNamespace) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new UnifiedRbacResourceNamespaceRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getHeaders())
            .post(newUnifiedRbacResourceNamespace);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    @Nonnull
    public UnifiedRbacResourceNamespaceCollectionRequest expand(@Nonnull final String value) {
        addExpandOption(value);
        return this;
    }

    /**
     * Sets the filter clause for the request
     *
     * @param value the filter clause
     * @return the updated request
     */
    @Nonnull
    public UnifiedRbacResourceNamespaceCollectionRequest filter(@Nonnull final String value) {
        addFilterOption(value);
        return this;
    }

    /**
     * Sets the order by clause for the request
     *
     * @param value the order by clause
     * @return the updated request
     */
    @Nonnull
    public UnifiedRbacResourceNamespaceCollectionRequest orderBy(@Nonnull final String value) {
        addOrderByOption(value);
        return this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    @Nonnull
    public UnifiedRbacResourceNamespaceCollectionRequest select(@Nonnull final String value) {
        addSelectOption(value);
        return this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    @Nonnull
    public UnifiedRbacResourceNamespaceCollectionRequest top(final int value) {
        addTopOption(value);
        return this;
    }

    /**
     * Sets the count value for the request
     *
     * @param value whether or not to return the count of objects with the request
     * @return the updated request
     */
    @Nonnull
    public UnifiedRbacResourceNamespaceCollectionRequest count(final boolean value) {
        addCountOption(value);
        return this;
    }
    /**
     * Sets the count value to true for the request
     *
     * @return the updated request
     */
    @Nonnull
    public UnifiedRbacResourceNamespaceCollectionRequest count() {
        addCountOption(true);
        return this;
    }
    /**
     * Sets the skip value for the request
     *
     * @param value of the number of items to skip
     * @return the updated request
     */
    @Nonnull
    public UnifiedRbacResourceNamespaceCollectionRequest skip(final int value) {
        addSkipOption(value);
        return this;
    }


    /**
     * Add Skip token for pagination
     * @param skipToken - Token for pagination
     * @return the updated request
     */
    @Nonnull
    public UnifiedRbacResourceNamespaceCollectionRequest skipToken(@Nonnull final String skipToken) {
    	addSkipTokenOption(skipToken);
        return this;
    }
}

