// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UpdateRecordingStatusOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Update Recording Status Operation Request.
 */
public class UpdateRecordingStatusOperationRequest extends BaseRequest<UpdateRecordingStatusOperation> {
	
    /**
     * The request for the UpdateRecordingStatusOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UpdateRecordingStatusOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UpdateRecordingStatusOperation.class);
    }

    /**
     * Gets the UpdateRecordingStatusOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UpdateRecordingStatusOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UpdateRecordingStatusOperation from the service
     *
     * @return the UpdateRecordingStatusOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UpdateRecordingStatusOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UpdateRecordingStatusOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UpdateRecordingStatusOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UpdateRecordingStatusOperation with a source
     *
     * @param sourceUpdateRecordingStatusOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UpdateRecordingStatusOperation> patchAsync(@Nonnull final UpdateRecordingStatusOperation sourceUpdateRecordingStatusOperation) {
        return sendAsync(HttpMethod.PATCH, sourceUpdateRecordingStatusOperation);
    }

    /**
     * Patches this UpdateRecordingStatusOperation with a source
     *
     * @param sourceUpdateRecordingStatusOperation the source object with updates
     * @return the updated UpdateRecordingStatusOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UpdateRecordingStatusOperation patch(@Nonnull final UpdateRecordingStatusOperation sourceUpdateRecordingStatusOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceUpdateRecordingStatusOperation);
    }

    /**
     * Creates a UpdateRecordingStatusOperation with a new object
     *
     * @param newUpdateRecordingStatusOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UpdateRecordingStatusOperation> postAsync(@Nonnull final UpdateRecordingStatusOperation newUpdateRecordingStatusOperation) {
        return sendAsync(HttpMethod.POST, newUpdateRecordingStatusOperation);
    }

    /**
     * Creates a UpdateRecordingStatusOperation with a new object
     *
     * @param newUpdateRecordingStatusOperation the new object to create
     * @return the created UpdateRecordingStatusOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UpdateRecordingStatusOperation post(@Nonnull final UpdateRecordingStatusOperation newUpdateRecordingStatusOperation) throws ClientException {
        return send(HttpMethod.POST, newUpdateRecordingStatusOperation);
    }

    /**
     * Creates a UpdateRecordingStatusOperation with a new object
     *
     * @param newUpdateRecordingStatusOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UpdateRecordingStatusOperation> putAsync(@Nonnull final UpdateRecordingStatusOperation newUpdateRecordingStatusOperation) {
        return sendAsync(HttpMethod.PUT, newUpdateRecordingStatusOperation);
    }

    /**
     * Creates a UpdateRecordingStatusOperation with a new object
     *
     * @param newUpdateRecordingStatusOperation the object to create/update
     * @return the created UpdateRecordingStatusOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UpdateRecordingStatusOperation put(@Nonnull final UpdateRecordingStatusOperation newUpdateRecordingStatusOperation) throws ClientException {
        return send(HttpMethod.PUT, newUpdateRecordingStatusOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UpdateRecordingStatusOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UpdateRecordingStatusOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

