// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UserExperienceAnalyticsCategory;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Experience Analytics Category Request.
 */
public class UserExperienceAnalyticsCategoryRequest extends BaseRequest<UserExperienceAnalyticsCategory> {
	
    /**
     * The request for the UserExperienceAnalyticsCategory
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserExperienceAnalyticsCategoryRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserExperienceAnalyticsCategory.class);
    }

    /**
     * Gets the UserExperienceAnalyticsCategory from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsCategory> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UserExperienceAnalyticsCategory from the service
     *
     * @return the UserExperienceAnalyticsCategory from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsCategory get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsCategory> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UserExperienceAnalyticsCategory delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UserExperienceAnalyticsCategory with a source
     *
     * @param sourceUserExperienceAnalyticsCategory the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsCategory> patchAsync(@Nonnull final UserExperienceAnalyticsCategory sourceUserExperienceAnalyticsCategory) {
        return sendAsync(HttpMethod.PATCH, sourceUserExperienceAnalyticsCategory);
    }

    /**
     * Patches this UserExperienceAnalyticsCategory with a source
     *
     * @param sourceUserExperienceAnalyticsCategory the source object with updates
     * @return the updated UserExperienceAnalyticsCategory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsCategory patch(@Nonnull final UserExperienceAnalyticsCategory sourceUserExperienceAnalyticsCategory) throws ClientException {
        return send(HttpMethod.PATCH, sourceUserExperienceAnalyticsCategory);
    }

    /**
     * Creates a UserExperienceAnalyticsCategory with a new object
     *
     * @param newUserExperienceAnalyticsCategory the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsCategory> postAsync(@Nonnull final UserExperienceAnalyticsCategory newUserExperienceAnalyticsCategory) {
        return sendAsync(HttpMethod.POST, newUserExperienceAnalyticsCategory);
    }

    /**
     * Creates a UserExperienceAnalyticsCategory with a new object
     *
     * @param newUserExperienceAnalyticsCategory the new object to create
     * @return the created UserExperienceAnalyticsCategory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsCategory post(@Nonnull final UserExperienceAnalyticsCategory newUserExperienceAnalyticsCategory) throws ClientException {
        return send(HttpMethod.POST, newUserExperienceAnalyticsCategory);
    }

    /**
     * Creates a UserExperienceAnalyticsCategory with a new object
     *
     * @param newUserExperienceAnalyticsCategory the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UserExperienceAnalyticsCategory> putAsync(@Nonnull final UserExperienceAnalyticsCategory newUserExperienceAnalyticsCategory) {
        return sendAsync(HttpMethod.PUT, newUserExperienceAnalyticsCategory);
    }

    /**
     * Creates a UserExperienceAnalyticsCategory with a new object
     *
     * @param newUserExperienceAnalyticsCategory the object to create/update
     * @return the created UserExperienceAnalyticsCategory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UserExperienceAnalyticsCategory put(@Nonnull final UserExperienceAnalyticsCategory newUserExperienceAnalyticsCategory) throws ClientException {
        return send(HttpMethod.PUT, newUserExperienceAnalyticsCategory);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsCategoryRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UserExperienceAnalyticsCategoryRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

