// Template Source: BaseEntityCollectionWithReferencesPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Host;
import com.microsoft.graph.security.models.HostComponent;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.security.requests.HostComponentCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.HostComponentCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.HostComponentCollectionResponse;
import com.microsoft.graph.security.models.HostComponent;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Host Component Collection With References Page.
 */
public class HostComponentCollectionWithReferencesPage extends BaseCollectionPage<HostComponent, HostComponentCollectionWithReferencesRequestBuilder> {

    /**
     * A collection page for HostComponent
     *
     * @param response the serialized HostComponentCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public HostComponentCollectionWithReferencesPage(@Nonnull final HostComponentCollectionResponse response, @Nullable final HostComponentCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }

    /**
     * Creates the collection page for HostComponent
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public HostComponentCollectionWithReferencesPage(@Nonnull final java.util.List<HostComponent> pageContents, @Nullable final HostComponentCollectionWithReferencesRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
