// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Artifact;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Artifact Request.
 */
public class ArtifactRequest extends BaseRequest<Artifact> {
	
    /**
     * The request for the Artifact
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ArtifactRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends Artifact> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the Artifact
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ArtifactRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Artifact.class);
    }

    /**
     * Gets the Artifact from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Artifact> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Artifact from the service
     *
     * @return the Artifact from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Artifact get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Artifact> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Artifact delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Artifact with a source
     *
     * @param sourceArtifact the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Artifact> patchAsync(@Nonnull final Artifact sourceArtifact) {
        return sendAsync(HttpMethod.PATCH, sourceArtifact);
    }

    /**
     * Patches this Artifact with a source
     *
     * @param sourceArtifact the source object with updates
     * @return the updated Artifact
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Artifact patch(@Nonnull final Artifact sourceArtifact) throws ClientException {
        return send(HttpMethod.PATCH, sourceArtifact);
    }

    /**
     * Creates a Artifact with a new object
     *
     * @param newArtifact the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Artifact> postAsync(@Nonnull final Artifact newArtifact) {
        return sendAsync(HttpMethod.POST, newArtifact);
    }

    /**
     * Creates a Artifact with a new object
     *
     * @param newArtifact the new object to create
     * @return the created Artifact
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Artifact post(@Nonnull final Artifact newArtifact) throws ClientException {
        return send(HttpMethod.POST, newArtifact);
    }

    /**
     * Creates a Artifact with a new object
     *
     * @param newArtifact the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Artifact> putAsync(@Nonnull final Artifact newArtifact) {
        return sendAsync(HttpMethod.PUT, newArtifact);
    }

    /**
     * Creates a Artifact with a new object
     *
     * @param newArtifact the object to create/update
     * @return the created Artifact
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Artifact put(@Nonnull final Artifact newArtifact) throws ClientException {
        return send(HttpMethod.PUT, newArtifact);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ArtifactRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ArtifactRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

