// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;
import com.microsoft.graph.security.requests.EdiscoveryCustodianRemoveHoldRequest;
import com.microsoft.graph.security.models.EdiscoveryCustodian;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.security.models.EdiscoveryCustodianRemoveHoldParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Custodian Remove Hold Request Builder.
 */
public class EdiscoveryCustodianRemoveHoldRequestBuilder extends BaseActionRequestBuilder<EdiscoveryCustodian> {

    private EdiscoveryCustodianRemoveHoldParameterSet body;
    /**
     * The request builder for this EdiscoveryCustodianRemoveHold
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryCustodianRemoveHoldRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    /**
     * The request builder for this EdiscoveryCustodianRemoveHold
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public EdiscoveryCustodianRemoveHoldRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final EdiscoveryCustodianRemoveHoldParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the EdiscoveryCustodianRemoveHoldRequest
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryCustodianRemoveHoldRequest instance
     */
    @Nonnull
    public EdiscoveryCustodianRemoveHoldRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the EdiscoveryCustodianRemoveHoldRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryCustodianRemoveHoldRequest instance
     */
    @Nonnull
    public EdiscoveryCustodianRemoveHoldRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EdiscoveryCustodianRemoveHoldRequest request = new EdiscoveryCustodianRemoveHoldRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
