// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;
import com.microsoft.graph.security.requests.EdiscoveryNoncustodialDataSourceReleaseRequest;
import com.microsoft.graph.security.models.EdiscoveryNoncustodialDataSource;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Noncustodial Data Source Release Request Builder.
 */
public class EdiscoveryNoncustodialDataSourceReleaseRequestBuilder extends BaseActionRequestBuilder<EdiscoveryNoncustodialDataSource> {

    /**
     * The request builder for this EdiscoveryNoncustodialDataSourceRelease
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryNoncustodialDataSourceReleaseRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the EdiscoveryNoncustodialDataSourceReleaseRequest
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryNoncustodialDataSourceReleaseRequest instance
     */
    @Nonnull
    public EdiscoveryNoncustodialDataSourceReleaseRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the EdiscoveryNoncustodialDataSourceReleaseRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the EdiscoveryNoncustodialDataSourceReleaseRequest instance
     */
    @Nonnull
    public EdiscoveryNoncustodialDataSourceReleaseRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final EdiscoveryNoncustodialDataSourceReleaseRequest request = new EdiscoveryNoncustodialDataSourceReleaseRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
