// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.VulnerabilityComponent;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Vulnerability Component Request.
 */
public class VulnerabilityComponentRequest extends BaseRequest<VulnerabilityComponent> {
	
    /**
     * The request for the VulnerabilityComponent
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public VulnerabilityComponentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, VulnerabilityComponent.class);
    }

    /**
     * Gets the VulnerabilityComponent from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VulnerabilityComponent> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the VulnerabilityComponent from the service
     *
     * @return the VulnerabilityComponent from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VulnerabilityComponent get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VulnerabilityComponent> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public VulnerabilityComponent delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this VulnerabilityComponent with a source
     *
     * @param sourceVulnerabilityComponent the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VulnerabilityComponent> patchAsync(@Nonnull final VulnerabilityComponent sourceVulnerabilityComponent) {
        return sendAsync(HttpMethod.PATCH, sourceVulnerabilityComponent);
    }

    /**
     * Patches this VulnerabilityComponent with a source
     *
     * @param sourceVulnerabilityComponent the source object with updates
     * @return the updated VulnerabilityComponent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VulnerabilityComponent patch(@Nonnull final VulnerabilityComponent sourceVulnerabilityComponent) throws ClientException {
        return send(HttpMethod.PATCH, sourceVulnerabilityComponent);
    }

    /**
     * Creates a VulnerabilityComponent with a new object
     *
     * @param newVulnerabilityComponent the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VulnerabilityComponent> postAsync(@Nonnull final VulnerabilityComponent newVulnerabilityComponent) {
        return sendAsync(HttpMethod.POST, newVulnerabilityComponent);
    }

    /**
     * Creates a VulnerabilityComponent with a new object
     *
     * @param newVulnerabilityComponent the new object to create
     * @return the created VulnerabilityComponent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VulnerabilityComponent post(@Nonnull final VulnerabilityComponent newVulnerabilityComponent) throws ClientException {
        return send(HttpMethod.POST, newVulnerabilityComponent);
    }

    /**
     * Creates a VulnerabilityComponent with a new object
     *
     * @param newVulnerabilityComponent the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<VulnerabilityComponent> putAsync(@Nonnull final VulnerabilityComponent newVulnerabilityComponent) {
        return sendAsync(HttpMethod.PUT, newVulnerabilityComponent);
    }

    /**
     * Creates a VulnerabilityComponent with a new object
     *
     * @param newVulnerabilityComponent the object to create/update
     * @return the created VulnerabilityComponent
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public VulnerabilityComponent put(@Nonnull final VulnerabilityComponent newVulnerabilityComponent) throws ClientException {
        return send(HttpMethod.PUT, newVulnerabilityComponent);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public VulnerabilityComponentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public VulnerabilityComponentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

