// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.termstore.models.Store;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Store Request Builder.
 */
public class StoreRequestBuilder extends BaseRequestBuilder<Store> {

    /**
     * The request builder for the Store
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public StoreRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the StoreRequest instance
     */
    @Nonnull
    public StoreRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the StoreRequest instance
     */
    @Nonnull
    public StoreRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.termstore.requests.StoreRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the Group collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.termstore.requests.GroupCollectionRequestBuilder groups() {
        return new com.microsoft.graph.termstore.requests.GroupCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("groups"), getClient(), null);
    }

    /**
     * Gets a request builder for the Group item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.termstore.requests.GroupRequestBuilder groups(@Nonnull final String id) {
        return new com.microsoft.graph.termstore.requests.GroupRequestBuilder(getRequestUrlWithAdditionalSegment("groups") + "/" + id, getClient(), null);
    }
    /**
     *  Gets a request builder for the Set collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public com.microsoft.graph.termstore.requests.SetCollectionRequestBuilder sets() {
        return new com.microsoft.graph.termstore.requests.SetCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("sets"), getClient(), null);
    }

    /**
     * Gets a request builder for the Set item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public com.microsoft.graph.termstore.requests.SetRequestBuilder sets(@Nonnull final String id) {
        return new com.microsoft.graph.termstore.requests.SetRequestBuilder(getRequestUrlWithAdditionalSegment("sets") + "/" + id, getClient(), null);
    }
}
