/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.BrowserSite;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BrowserSiteRequest
extends BaseRequest<BrowserSite> {
    public BrowserSiteRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, BrowserSite.class);
    }

    @Nonnull
    public CompletableFuture<BrowserSite> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public BrowserSite get() throws ClientException {
        return (BrowserSite)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<BrowserSite> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public BrowserSite delete() throws ClientException {
        return (BrowserSite)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<BrowserSite> patchAsync(@Nonnull BrowserSite sourceBrowserSite) {
        return this.sendAsync(HttpMethod.PATCH, sourceBrowserSite);
    }

    @Nullable
    public BrowserSite patch(@Nonnull BrowserSite sourceBrowserSite) throws ClientException {
        return (BrowserSite)this.send(HttpMethod.PATCH, sourceBrowserSite);
    }

    @Nonnull
    public CompletableFuture<BrowserSite> postAsync(@Nonnull BrowserSite newBrowserSite) {
        return this.sendAsync(HttpMethod.POST, newBrowserSite);
    }

    @Nullable
    public BrowserSite post(@Nonnull BrowserSite newBrowserSite) throws ClientException {
        return (BrowserSite)this.send(HttpMethod.POST, newBrowserSite);
    }

    @Nonnull
    public CompletableFuture<BrowserSite> putAsync(@Nonnull BrowserSite newBrowserSite) {
        return this.sendAsync(HttpMethod.PUT, newBrowserSite);
    }

    @Nullable
    public BrowserSite put(@Nonnull BrowserSite newBrowserSite) throws ClientException {
        return (BrowserSite)this.send(HttpMethod.PUT, newBrowserSite);
    }

    @Nonnull
    public BrowserSiteRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public BrowserSiteRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

