/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.Participant;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.ParticipantCollectionPage;
import com.microsoft.graph.requests.ParticipantCollectionRequestBuilder;
import com.microsoft.graph.requests.ParticipantCollectionResponse;
import com.microsoft.graph.requests.ParticipantRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ParticipantCollectionRequest
extends BaseEntityCollectionRequest<Participant, ParticipantCollectionResponse, ParticipantCollectionPage> {
    public ParticipantCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ParticipantCollectionResponse.class, ParticipantCollectionPage.class, ParticipantCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Participant> postAsync(@Nonnull Participant newParticipant) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ParticipantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newParticipant);
    }

    @Nonnull
    public Participant post(@Nonnull Participant newParticipant) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ParticipantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newParticipant);
    }

    @Nonnull
    public ParticipantCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public ParticipantCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public ParticipantCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public ParticipantCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public ParticipantCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public ParticipantCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public ParticipantCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public ParticipantCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public ParticipantCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

